package org.jboss.cache.search;

import org.testng.annotations.Test;
import org.jboss.cache.Fqn;
import org.jboss.cache.search.CacheEntityId;

/**
 * @author Navin Surtani  - navin@surtani.org
 */

@Test
public class CacheEntityIdTest
{

   @Test (expectedExceptions = NullPointerException.class)
   public void testNullFqn()
   {
      CacheEntityId nullFqn = new CacheEntityId(null, "key");
   }


   @Test (expectedExceptions = NullPointerException.class)
   public void testNullKey()
   {
      CacheEntityId nullKey = new CacheEntityId(Fqn.fromString("/a/b/c"), null);
   }

   @Test (expectedExceptions = NullPointerException.class)
   public void testNullDocId()
   {
      CacheEntityId nulldoc = new CacheEntityId(null);
   }



}
