package org.jboss.cache.search;

import org.testng.annotations.Test;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;

/**
 * @author Navin Surtani  - navin@surtani.org
 */

@Test (groups = "functional")
public class SearchableCacheImplTest
{

   @Test (expectedExceptions = NullPointerException.class)
   public void testConstructorWithNullCache()
   {
      SearchableCacheImpl nullCache = new SearchableCacheImpl(null, null);
      
   }

   @Test (expectedExceptions = NullPointerException.class)
   public void testConstructorWithNullSearchFactory()
   {
      Cache cache = new DefaultCacheFactory().createCache();
      SearchableCacheImpl nullSearchFactory = new SearchableCacheImpl(cache, null);
   }
}
