package org.jboss.cache.search;

import org.jboss.cache.Fqn;
import org.testng.annotations.Test;

/**
 * @author Navin Surtani  - navin@surtani.org
 *         <p/>
 *         Unit-test class for the Transformer class.
 */

@Test(groups = "functional")
public class TransformerTest

{
   /**
    * Tests the generateId method.
    */

   public void testGenerateId() throws InvalidKeyException
   {

      Fqn fqn = Fqn.fromString("/a/b/c");
      String key = "key";

      String generatedId = Transformer.generateId(fqn, key);

      assert generatedId.contentEquals("Fqn=[/a/b/c]Key=[key]");

      assert !generatedId.contentEquals("/ab/c/d");
   }

   /**
    * Tests the getFqn method.
    */
   public void testGetFqn()
   {
      Fqn fqn = Transformer.getFqn("Fqn=[/cat/dog/person]Key=[key]");

      Fqn expectedFqn = Fqn.fromString("/cat/dog/person");

      assert fqn.equals(expectedFqn);

      expectedFqn = Fqn.fromString("/dog/cat/person");

      assert !fqn.equals(expectedFqn);

   }

   /**
    * Tests the getKey method.
    */
   public void testGetKey()
   {
      String key = Transformer.getKey("Fqn=[/a/b/c]Key=[thisIsMyKey]");

      assert key.contentEquals("thisIsMyKey");

      assert !key.contentEquals("thisIsNotMyKey");

   }

   @Test(expectedExceptions = NullPointerException.class)
   public void testGetKeyWithNull()
   {
      Transformer.getKey(null);
   }

   @Test(expectedExceptions = InvalidFqnException.class)
   public void testGenerateIdWithHackedString() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/Fqn=[/a/b/c"), "x");
   }

   @Test(expectedExceptions = InvalidFqnException.class)
   public void testGenerateIdWithHackedFqn() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/Fqn=[/a/b/c"), "x");
   }

   @Test(expectedExceptions = InvalidFqnException.class)
   public void testGenerateIdWithHackedFqn2() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/]Key=[/a/b/c"), "x");
   }

   @Test(expectedExceptions = InvalidKeyException.class)
   public void testGenerateIdWithHackedKey() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/a/b/c"), "]Key=[");
   }

   @Test(expectedExceptions = InvalidKeyException.class)
   public void testGenerateIdWithHackedKey2() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/a/b/c"), "Fqn=[");
   }

   @Test(expectedExceptions = NullPointerException.class)
   public void testGenerateIdWithNullKey() throws InvalidKeyException
   {
      Transformer.generateId(Fqn.fromString("/a/b/c"), null);
   }

   @Test(expectedExceptions = NullPointerException.class)
   public void testGenerateIdWithNullFqn() throws InvalidKeyException
   {
      Transformer.generateId(null, "x");
   }
}
