package org.jboss.cache.search.helper;

import org.jboss.cache.search.test.Person;

import java.io.File;

/**
 * @author Navin Surtani  - navin@surtani.org
 */
public class IndexCleanUp
{

   public static void cleanUpIndexes()
   {
      Class[] knownClasses = {Person.class};
      for (Class c : knownClasses)
      {
         String dirName = c.getName();
         File file = new File(dirName);
         if (file.exists())
         {
            recursiveDelete(file);
         }
      }
   }

   private static void recursiveDelete(File f)
   {
      if (f.isDirectory())
      {
         File[] files = f.listFiles();
         for (File file : files) recursiveDelete(file);
      }
      else
      {
         f.delete();
      }
   }

}

