/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.XmlUpdateRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.NamedList;
import org.apache.solr.util.XML;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHarness {
    private SolrCore core;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private DocumentBuilder builder;
    XmlUpdateRequestHandler updater;

    public TestHarness(String dataDirectory) {
        this(dataDirectory, "schema.xml");
    }

    public TestHarness(String dataDirectory, String schemaFile) {
        this(dataDirectory, "solrconfig.xml", schemaFile);
    }

    public TestHarness(String dataDirectory, String confFile, String schemaFile) {
        try {
            SolrConfig.initConfig(confFile);
            this.core = new SolrCore(dataDirectory, new IndexSchema(schemaFile));
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.updater = new XmlUpdateRequestHandler();
            this.updater.init(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String update(String xml) {
        StringReader req = new StringReader(xml);
        StringWriter writer = new StringWriter(32000);
        this.updater.doLegacyUpdate((Reader)req, (Writer)writer);
        return writer.toString();
    }

    public String validateUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "0");
    }

    public String validateErrorUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "1");
    }

    public String checkUpdateStatus(String xml, String code) throws SAXException {
        try {
            String res = this.update(xml);
            String valid = this.validateXPath(res, "//result[@status=" + code + "]");
            return null == valid ? null : res;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    public String validateAddDoc(String ... fieldsAndValues) throws XPathExpressionException, SAXException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<add>");
        this.appendSimpleDoc(buf, fieldsAndValues);
        buf.append("</add>");
        String res = this.update(buf.toString());
        String valid = this.validateXPath(res, "//result[@status=0]");
        return null == valid ? null : res;
    }

    public String validateQuery(SolrQueryRequest req, String ... tests) throws IOException, Exception {
        String res = this.query(req);
        return this.validateXPath(res, tests);
    }

    public String query(SolrQueryRequest req) throws IOException, Exception {
        return this.query(req.getQueryType(), req);
    }

    public String query(String handler, SolrQueryRequest req) throws IOException, Exception {
        SolrQueryResponse rsp = new SolrQueryResponse();
        this.core.execute(this.core.getRequestHandler(handler), req, rsp);
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
        StringWriter sw = new StringWriter(32000);
        QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(req);
        responseWriter.write((Writer)sw, req, rsp);
        req.close();
        return sw.toString();
    }

    public String validateXPath(String xml, String ... tests) throws XPathExpressionException, SAXException {
        if (tests == null || tests.length == 0) {
            return null;
        }
        Document document = null;
        try {
            document = this.builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("Totally weird UTF-8 exception", e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("Totally weird io exception", e2);
        }
        for (String xp : tests) {
            Boolean bool = (Boolean)this.xpath.evaluate(xp = xp.trim(), document, XPathConstants.BOOLEAN);
            if (bool.booleanValue()) continue;
            return xp;
        }
        return null;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public void close() {
        this.core.close();
    }

    public void appendSimpleDoc(StringBuffer buf, String ... fieldsAndValues) throws IOException {
        buf.append(TestHarness.makeSimpleDoc(fieldsAndValues));
    }

    public static StringBuffer makeSimpleDoc(String ... fieldsAndValues) {
        try {
            StringWriter w = new StringWriter();
            w.append("<doc>");
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                XML.writeXML(w, "field", fieldsAndValues[i + 1], "name", fieldsAndValues[i]);
            }
            w.append("</doc>");
            return w.getBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteByQuery(String q) {
        return TestHarness.delete("query", q);
    }

    public static String deleteById(String id) {
        return TestHarness.delete("id", id);
    }

    private static String delete(String deltype, String val) {
        try {
            StringWriter r = new StringWriter();
            r.write("<delete>");
            XML.writeXML(r, deltype, val);
            r.write("</delete>");
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.simpleTag("optimize", args);
    }

    private static String simpleTag(String tag, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                XML.writeXML(r, tag, null);
            } else {
                XML.writeXML(r, tag, null, new Object[]{args});
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String commit(String ... args) {
        return TestHarness.simpleTag("commit", args);
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit) {
        LocalRequestFactory f = new LocalRequestFactory();
        f.qtype = qtype;
        f.start = start;
        f.limit = limit;
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, String ... args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        for (int i = 0; i < args.length; i += 2) {
            f.args.put(args[i], args[i + 1]);
        }
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, Map<String, String> args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        f.args.putAll(args);
        return f;
    }

    public class LocalRequestFactory {
        public String qtype = "standard";
        public int start = 0;
        public int limit = 1000;
        public Map<String, String> args = new HashMap<String, String>();

        public LocalSolrQueryRequest makeRequest(String ... q) {
            if (q.length == 1) {
                return new LocalSolrQueryRequest(TestHarness.this.getCore(), q[0], this.qtype, this.start, this.limit, this.args);
            }
            return new LocalSolrQueryRequest(TestHarness.this.getCore(), new NamedList(Arrays.asList(q)));
        }
    }
}

