/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.test;

import java.util.Random;
import org.apache.solr.util.BCDUtils;
import org.apache.solr.util.test.Converter;

public class TestNumberUtils {
    static Random rng = new Random();
    static int[] special = new int[]{0, 10, 100, 1000, 10000, Integer.MAX_VALUE, Integer.MIN_VALUE};
    static long[] lspecial = new long[]{0L, 10L, 100L, 1000L, 10000L, 2L, 4L, 8L, 256L, 16384L, 32768L, 65536L, Integer.MAX_VALUE, Integer.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE};
    static float[] fspecial = new float[]{0.0f, 1.0f, 2.0f, 4.0f, 8.0f, 256.0f, 16384.0f, 32768.0f, 65536.0f, 0.1f, 0.25f, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.MIN_VALUE, Float.MAX_VALUE};
    static double[] dspecial = new double[]{0.0, 1.0, 2.0, 4.0, 8.0, 256.0, 16384.0, 32768.0, 65536.0, 0.1, 0.25, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.4E-45f, 3.4028234663852886E38, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.MIN_VALUE, Double.MAX_VALUE};

    private static String arrstr(char[] arr, int start, int end) {
        String str = "[";
        for (int i = start; i < end; ++i) {
            str = str + arr[i] + "(" + arr[i] + "),";
        }
        return str + "]";
    }

    static int getSpecial() {
        int i = rng.nextInt();
        int j = rng.nextInt();
        if ((i & 0x10) != 0) {
            return j;
        }
        return special[(j & Integer.MAX_VALUE) % special.length] * ((i & 0x20) == 0 ? 1 : -1) + ((i & 3) - 1);
    }

    static long getLongSpecial() {
        int i = rng.nextInt();
        long j = rng.nextLong();
        if ((i & 0x10) != 0) {
            return j;
        }
        return lspecial[((int)j & Integer.MAX_VALUE) % special.length] * (long)((i & 0x20) == 0 ? 1 : -1) + (long)((i & 3) - 1);
    }

    static float getFloatSpecial() {
        int i = rng.nextInt();
        int j = rng.nextInt();
        float f = Float.intBitsToFloat(j);
        if (f != f) {
            f = 0.0f;
        }
        if ((i & 0x10) != 0) {
            return f;
        }
        return fspecial[(j & Integer.MAX_VALUE) % fspecial.length] * (float)((i & 0x20) == 0 ? 1 : -1) + (float)((i & 3) - 1);
    }

    static double getDoubleSpecial() {
        int i = rng.nextInt();
        long j = rng.nextLong();
        double f = Double.longBitsToDouble(j);
        if (f != f) {
            f = 0.0;
        }
        if ((i & 0x10) != 0) {
            return f;
        }
        return dspecial[((int)j & Integer.MAX_VALUE) % dspecial.length] * (double)((i & 0x20) == 0 ? 1 : -1) + (double)((i & 3) - 1);
    }

    public static void test(Comparable n1, Comparable n2, Converter conv) {
        String s1 = n1.toString();
        String s2 = n2.toString();
        String v1 = conv.toInternal(s1);
        String v2 = conv.toInternal(s2);
        String out1 = conv.toExternal(v1);
        String out2 = conv.toExternal(v2);
        int c1 = n1.compareTo(n2);
        int c2 = v1.compareTo(v2);
        if (c1 == 0 && c2 != 0 || c1 < 0 && c2 >= 0 || c1 > 0 && c2 <= 0 || !out1.equals(s1) || !out2.equals(s2)) {
            int ii;
            System.out.println("Comparison error:" + s1 + "," + s2);
            System.out.print("v1=");
            for (ii = 0; ii < v1.length(); ++ii) {
                System.out.print(" " + v1.charAt(ii));
            }
            System.out.print("\nv2=");
            for (ii = 0; ii < v2.length(); ++ii) {
                System.out.print(" " + v2.charAt(ii));
            }
            System.out.println("\nout1='" + out1 + "', out2='" + out2 + "'");
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        int iter = 1000000;
        int arrsz = 100000;
        int ret = 0;
        int num = 0;
        String test = "b100";
        String clazz = "NoClass";
        for (int argnum = 0; argnum < args.length; ++argnum) {
            String arg = args[argnum];
            if ("-t".equals(arg)) {
                test = args[++argnum];
            }
            if ("-i".equals(arg)) {
                iter = Integer.parseInt(args[++argnum]);
            }
            if ("-a".equals(arg)) {
                arrsz = Integer.parseInt(args[++argnum]);
            }
            if ("-c".equals(arg)) {
                clazz = args[++argnum];
            }
            if ("-r".equals(arg)) {
                rng.setSeed(Long.parseLong(args[++argnum]));
            }
            if (!"-n".equals(arg)) continue;
            num = Integer.parseInt(args[++argnum]);
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(clazz);
        }
        catch (Exception e) {
            cls = Class.forName("solr.util.test." + clazz);
        }
        Converter conv = (Converter)cls.newInstance();
        long startTime = System.currentTimeMillis();
        if ("ispecial".equals(test)) {
            for (int i = 0; i < iter; ++i) {
                Integer i1 = TestNumberUtils.getSpecial();
                Integer i2 = TestNumberUtils.getSpecial();
                TestNumberUtils.test(i1, i2, conv);
            }
        } else if ("lspecial".equals(test)) {
            for (int i = 0; i < iter; ++i) {
                Long f1 = TestNumberUtils.getLongSpecial();
                Long f2 = TestNumberUtils.getLongSpecial();
                TestNumberUtils.test(f1, f2, conv);
            }
        } else if ("fspecial".equals(test)) {
            for (int i = 0; i < iter; ++i) {
                Float f1 = Float.valueOf(TestNumberUtils.getFloatSpecial());
                Float f2 = Float.valueOf(TestNumberUtils.getFloatSpecial());
                TestNumberUtils.test(f1, f2, conv);
            }
        } else if ("dspecial".equals(test)) {
            for (int i = 0; i < iter; ++i) {
                Double f1 = TestNumberUtils.getDoubleSpecial();
                Double f2 = TestNumberUtils.getDoubleSpecial();
                TestNumberUtils.test(f1, f2, conv);
            }
        } else if ("10kout".equals(test)) {
            String n = Integer.toString(num);
            char[] arr = new char[n.length()];
            char[] arr2 = new char[n.length() + 1];
            n.getChars(0, n.length(), arr, 0);
            for (int i = 0; i < iter; ++i) {
                ret += BCDUtils.base10toBase100SortableInt(arr, 0, arr.length, arr2, arr2.length);
            }
        } else if ("internal".equals(test) || "external".equals(test)) {
            int min = -1000000;
            int max = 1000000;
            String[] arr = new String[arrsz];
            String[] internal = new String[arrsz];
            if ("external".equals(test)) {
                int i;
                for (i = 0; i < arrsz; ++i) {
                    int val = rng.nextInt();
                    arr[i] = Integer.toString(rng.nextInt());
                    internal[i] = conv.toInternal(arr[i]);
                }
                for (i = 0; i < iter; ++i) {
                    int slot = i % arrsz;
                    arr[slot] = conv.toExternal(internal[slot]);
                    ret += arr[slot].length();
                }
            } else {
                int i;
                for (i = 0; i < arrsz; ++i) {
                    int val = rng.nextInt();
                    arr[i] = Integer.toString(rng.nextInt());
                }
                for (i = 0; i < iter; ++i) {
                    int slot = i % arrsz;
                    internal[slot] = conv.toInternal(arr[slot]);
                    ret += internal[slot].length();
                }
            }
        } else if ("itest".equals(test) || "ltest".equals(test) || "ftest".equals(test)) {
            long internalLen = 0L;
            long externalLen = 0L;
            for (int i = 0; i < iter; ++i) {
                int ii;
                Number i2;
                Number i1;
                Object n1 = null;
                Object n2 = null;
                if ("itest".equals(test)) {
                    i1 = rng.nextInt();
                    i2 = rng.nextInt();
                    if (i < 10000) {
                        i1 = (Integer)i1 % 250 - 125;
                        i2 = (Integer)i2 % 250 - 125;
                    } else if (i < 500000) {
                        i1 = (Integer)i1 % 25000 - 12500;
                        i2 = (Integer)i2 % 25000 - 12500;
                    }
                    n1 = i1;
                    n2 = i2;
                } else if ("ltest".equals(test)) {
                    i1 = rng.nextLong();
                    i2 = rng.nextLong();
                    if (i < 10000) {
                        i1 = (Long)i1 % 250L - 125L;
                        i2 = (Long)i2 % 250L - 125L;
                    } else if (i < 500000) {
                        i1 = (Long)i1 % 25000L - 12500L;
                        i2 = (Long)i2 % 25000L - 12500L;
                    }
                    n1 = i1;
                    n2 = i2;
                } else if ("ftest".equals(test)) {
                    if (i < 10000) {
                        i1 = Float.valueOf((float)(rng.nextInt() % 250) - 125.0f);
                        i2 = Float.valueOf((float)(rng.nextInt() % 250) - 125.0f);
                    } else if (i < 300000) {
                        i1 = Float.valueOf((float)(rng.nextInt() % 2500) - 1250.0f);
                        i2 = Float.valueOf((float)(rng.nextInt() % 2500) - 1250.0f);
                    } else if (i < 500000) {
                        i1 = Float.valueOf(rng.nextFloat() / rng.nextFloat());
                        i2 = Float.valueOf(rng.nextFloat() / rng.nextFloat());
                    } else {
                        i1 = Float.valueOf(Float.intBitsToFloat(rng.nextInt()));
                        i2 = Float.valueOf(Float.intBitsToFloat(rng.nextInt()));
                    }
                    n1 = i1;
                    n2 = i2;
                }
                String s1 = n1.toString();
                String s2 = n2.toString();
                String v1 = conv.toInternal(s1);
                String v2 = conv.toInternal(s2);
                String out1 = conv.toExternal(v1);
                String out2 = conv.toExternal(v2);
                externalLen += (long)s1.length();
                internalLen += (long)v1.length();
                int c1 = n1.compareTo(n2);
                int c2 = v1.compareTo(v2);
                if (!(c1 == 0 && c2 != 0 || c1 < 0 && c2 >= 0 || c1 > 0 && c2 <= 0 || !out1.equals(s1)) && out2.equals(s2)) continue;
                System.out.println("Comparison error:" + s1 + "," + s2);
                System.out.print("v1=");
                for (ii = 0; ii < v1.length(); ++ii) {
                    System.out.print(" " + v1.charAt(ii));
                }
                System.out.print("\nv2=");
                for (ii = 0; ii < v2.length(); ++ii) {
                    System.out.print(" " + v2.charAt(ii));
                }
                System.out.println("\nout1='" + out1 + "', out2='" + out2 + "'");
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("time=" + (endTime - startTime));
        System.out.println("ret=" + ret);
    }
}

