/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.util.Immutables;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BuddyGroup
implements Serializable {
    private static final long serialVersionUID = 5391883716108410301L;
    private String groupName;
    private Address dataOwner;
    private Date lastModified = new Date();
    private final Vector<Address> buddies = new Vector();

    public String getGroupName() {
        return this.groupName;
    }

    protected void setGroupName(String groupName) {
        this.groupName = groupName;
        this.lastModified = new Date();
    }

    public Address getDataOwner() {
        return this.dataOwner;
    }

    protected void setDataOwner(Address dataOwner) {
        this.dataOwner = dataOwner;
        this.lastModified = new Date();
    }

    public List<Address> getBuddies() {
        return Immutables.immutableListCopy(this.buddies);
    }

    protected void addBuddies(Collection<Address> buddies) {
        this.buddies.addAll(buddies);
        this.lastModified = new Date();
    }

    protected void removeBuddies(Collection<Address> buddies) {
        this.buddies.removeAll(buddies);
        this.lastModified = new Date();
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("BuddyGroup: (");
        b.append("dataOwner: ").append(this.dataOwner).append(", ");
        b.append("groupName: ").append(this.groupName).append(", ");
        b.append("buddies: ").append(this.buddies).append(",");
        b.append("lastModified: ").append(this.lastModified).append(")");
        return b.toString();
    }

    public Vector<Address> getBuddiesAsVector() {
        return this.buddies;
    }
}

