/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.remote;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.interceptors.InterceptorChain;

public class ClusteredGetCommand
implements ReplicableCommand {
    public static final int METHOD_ID = 22;
    private DataCommand dataCommand;
    private boolean searchBackupSubtrees;
    private DataContainer dataContainer;
    private InterceptorChain interceptorChain;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();

    public ClusteredGetCommand(boolean searchBackupSubtrees, DataCommand dataCommand) {
        this.searchBackupSubtrees = searchBackupSubtrees;
        this.dataCommand = dataCommand;
    }

    public ClusteredGetCommand() {
    }

    public void initialize(DataContainer dataContainer, InterceptorChain interceptorChain) {
        this.dataContainer = dataContainer;
        this.interceptorChain = interceptorChain;
    }

    public Object perform(InvocationContext context) throws Throwable {
        if (trace) {
            log.trace((Object)("Clustered Get called with params: " + this.dataCommand + ", " + this.searchBackupSubtrees));
        }
        Object callResults = null;
        try {
            if (trace) {
                log.trace((Object)("Clustered get: invoking call with Fqn " + this.dataCommand.getFqn()));
            }
            InvocationContext ctx = this.interceptorChain.getInvocationContext();
            ctx.setOriginLocal(false);
            callResults = this.dataCommand.perform(ctx);
            boolean found = this.validResult(callResults);
            if (trace) {
                log.trace((Object)("Got result " + callResults + ", found=" + found));
            }
            if (found && callResults == null) {
                callResults = this.createEmptyResults();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Problems processing clusteredGet call", (Throwable)e);
        }
        ArrayList<Object> results = new ArrayList<Object>(2);
        if (callResults != null) {
            results.add(true);
            results.add(callResults);
        } else {
            results.add(false);
            results.add(null);
        }
        return results;
    }

    public int getCommandId() {
        return 22;
    }

    private boolean validResult(Object callResults) {
        if (this.dataCommand instanceof GetDataMapCommand || this.dataCommand instanceof GetChildrenNamesCommand) {
            return callResults != null && this.dataContainer.exists(this.dataCommand.getFqn());
        }
        return this.dataCommand instanceof ExistsCommand && (Boolean)callResults != false;
    }

    private Object createEmptyResults() {
        if (this.dataCommand instanceof GetDataMapCommand || this.dataCommand instanceof GetChildrenNamesCommand) {
            return Collections.emptyMap();
        }
        return null;
    }

    public Boolean getSearchBackupSubtrees() {
        return this.searchBackupSubtrees;
    }

    public DataCommand getDataCommand() {
        return this.dataCommand;
    }

    public Object[] getParameters() {
        return new Object[]{this.dataCommand, this.searchBackupSubtrees};
    }

    public void setParameters(int commandId, Object[] args) {
        this.dataCommand = (DataCommand)args[0];
        this.searchBackupSubtrees = (Boolean)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        if (this.dataCommand != null ? !this.dataCommand.equals(that.dataCommand) : that.dataCommand != null) {
            return false;
        }
        return this.searchBackupSubtrees == that.searchBackupSubtrees;
    }

    public int hashCode() {
        int result = this.dataCommand != null ? this.dataCommand.hashCode() : 0;
        result = 31 * result + (this.searchBackupSubtrees ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ClusteredGetCommand{dataCommand=" + this.dataCommand + ", searchBackupSubtrees=" + this.searchBackupSubtrees + '}';
    }
}

