/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Version;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.BootstrapFactory;
import org.jboss.cache.factories.BuddyManagerFactory;
import org.jboss.cache.factories.CommandsMetaFactory;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.ContextMetaFactory;
import org.jboss.cache.factories.EmptyConstructorFactory;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.LockManagerFactory;
import org.jboss.cache.factories.NodeMetaFactory;
import org.jboss.cache.factories.RegionManagerFactory;
import org.jboss.cache.factories.ReplicationQueueFactory;
import org.jboss.cache.factories.RuntimeConfigAwareFactory;
import org.jboss.cache.factories.StateTransferFactory;
import org.jboss.cache.factories.StateTransferManagerFactory;
import org.jboss.cache.factories.TransactionManagerFactory;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.util.BeanUtils;
import org.jboss.cache.util.reflect.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class ComponentRegistry {
    Map<Class, Class<? extends ComponentFactory>> defaultFactories = null;
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected static final Object NULL_COMPONENT = new Object();
    final Map<String, Component> componentLookup = new HashMap<String, Component>();
    CacheStatus state = CacheStatus.INSTANTIATED;
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;

    public ComponentRegistry(Configuration configuration, CacheSPI cache) {
        try {
            this.registerDefaultClassLoader(null);
            this.registerComponent(this, ComponentRegistry.class);
            this.registerComponent(configuration, Configuration.class);
            this.registerComponent(new BootstrapFactory(cache, configuration, this), BootstrapFactory.class);
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct ComponentRegistry", e);
        }
    }

    public CacheStatus getState() {
        return this.state;
    }

    public void wireDependencies(Object target) throws ConfigurationException {
        try {
            List<Method> methods = ReflectionUtil.getAllMethods(target.getClass(), Inject.class);
            for (Method method : methods) {
                this.invokeInjectionMethod(target, method);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure component (type: " + target.getClass() + ", instance " + target + ")", e);
        }
    }

    public void registerDefaultClassLoader(ClassLoader loader) {
        this.registerComponent(loader == null ? this.getClass().getClassLoader() : loader, ClassLoader.class);
        this.componentLookup.get((Object)ClassLoader.class.getName()).nonVolatile = true;
    }

    private Set<Class<? extends ComponentFactory>> getHardcodedFactories() {
        HashSet<Class<? extends ComponentFactory>> s = new HashSet<Class<? extends ComponentFactory>>();
        s.add(BootstrapFactory.class);
        s.add(BuddyManagerFactory.class);
        s.add(EmptyConstructorFactory.class);
        s.add(InterceptorChainFactory.class);
        s.add(RuntimeConfigAwareFactory.class);
        s.add(TransactionManagerFactory.class);
        s.add(ReplicationQueueFactory.class);
        s.add(LockManagerFactory.class);
        s.add(ContextMetaFactory.class);
        s.add(NodeMetaFactory.class);
        s.add(StateTransferManagerFactory.class);
        s.add(StateTransferFactory.class);
        s.add(RegionManagerFactory.class);
        s.add(NodeMetaFactory.class);
        s.add(CommandsMetaFactory.class);
        return s;
    }

    public void registerComponent(Object component, Class type) {
        Component c;
        String name = type.getName();
        Component old = this.componentLookup.get(name);
        if (old != null && old.instance.equals(component)) {
            if (trace) {
                log.trace((Object)("Attempting to register a component equal to one that already exists under the same name (" + name + ").  Not doing anything."));
            }
            return;
        }
        if (old != null) {
            if (trace) {
                log.trace((Object)("Replacing old component " + old + " with new instance " + component));
            }
            old.instance = component;
            old.methodsScanned = false;
            c = old;
            if (this.state == CacheStatus.STARTED) {
                this.populateLifecycleMethods();
            }
        } else {
            c = new Component();
            c.name = name;
            c.instance = component;
            if (trace) {
                log.trace((Object)("Registering component " + c + " under name " + name));
            }
            this.componentLookup.put(name, c);
        }
        c.nonVolatile = component.getClass().isAnnotationPresent(NonVolatile.class);
        this.addComponentDependencies(c);
        c.injectDependencies();
    }

    protected void addComponentDependencies(Component c) {
        Class<?> type = c.instance.getClass();
        List<Method> methods = ReflectionUtil.getAllMethods(type, Inject.class);
        c.injectionMethods.clear();
        c.injectionMethods.addAll(methods);
    }

    protected void invokeInjectionMethod(Object o, Method m) {
        Class<?>[] dependencies = m.getParameterTypes();
        Object[] params = new Object[dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            params[i] = this.getOrCreateComponent(dependencies[i]);
        }
        ReflectionUtil.invokeAccessibly(o, m, params);
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass) {
        T component = this.getComponent(componentClass);
        if (component == null) {
            component = this.getFromConfiguration(componentClass);
            boolean attemptedFactoryConstruction = false;
            if (component == null) {
                ComponentFactory factory = this.getFactory(componentClass);
                component = factory.construct(componentClass);
                attemptedFactoryConstruction = true;
            }
            if (component != null) {
                this.registerComponent(component, componentClass);
            } else if (attemptedFactoryConstruction) {
                if (trace) {
                    log.trace((Object)("Registering a null for component " + componentClass.getSimpleName()));
                }
                this.registerNullComponent(componentClass);
            }
        }
        return component;
    }

    protected ComponentFactory getFactory(Class componentClass) {
        Class<? extends ComponentFactory> cfClass;
        if (this.defaultFactories == null) {
            this.scanDefaultFactories();
        }
        if ((cfClass = this.defaultFactories.get(componentClass)) == null) {
            throw new ConfigurationException("No registered default factory for component " + componentClass + " found!");
        }
        ComponentFactory cf = this.getComponent(cfClass);
        if (cf == null) {
            cf = this.instantiateFactory(cfClass);
            if (cf == null) {
                throw new ConfigurationException("Unable to locate component factory for component " + componentClass);
            }
            this.registerComponent(cf, cfClass);
        }
        Component c = this.componentLookup.get(cfClass.getName());
        if (c.instance != cf) {
            throw new ConfigurationException("Component factory " + cfClass + " incorrectly registered!");
        }
        return cf;
    }

    void scanDefaultFactories() {
        this.defaultFactories = new HashMap<Class, Class<? extends ComponentFactory>>();
        Set<Class<? extends ComponentFactory>> factories = this.getHardcodedFactories();
        for (Class<? extends ComponentFactory> factory : factories) {
            DefaultFactoryFor dFFAnnotation = factory.getAnnotation(DefaultFactoryFor.class);
            for (Class targetClass : dFFAnnotation.classes()) {
                this.defaultFactories.put(targetClass, factory);
            }
        }
    }

    ComponentFactory instantiateFactory(Class<? extends ComponentFactory> factory) {
        try {
            return factory.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate factory " + factory, e);
        }
    }

    void registerNullComponent(Class type) {
        this.registerComponent(NULL_COMPONENT, type);
    }

    protected <T> T getFromConfiguration(Class<T> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in configuration for an instance of " + componentClass + " that may have been injected from an external source."));
        }
        Method getter = BeanUtils.getterMethod(Configuration.class, componentClass);
        Object returnValue = null;
        if (getter != null) {
            try {
                returnValue = getter.invoke((Object)this.getConfiguration(), new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke getter " + getter + " on Configuration.class!"), (Throwable)e);
            }
        }
        if (returnValue == null && (getter = BeanUtils.getterMethod(RuntimeConfig.class, componentClass)) != null) {
            try {
                returnValue = getter.invoke((Object)this.getConfiguration().getRuntimeConfig(), new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke getter " + getter + " on RuntimeConfig.class!"), (Throwable)e);
            }
        }
        return (T)returnValue;
    }

    protected Configuration getConfiguration() {
        return this.getComponent(Configuration.class);
    }

    public <T> T getComponent(Class<T> type) {
        Component wrapper = this.componentLookup.get(type.getName());
        if (wrapper == null) {
            return null;
        }
        return (T)(wrapper.instance == NULL_COMPONENT ? null : wrapper.instance);
    }

    public void rewire() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            c.injectDependencies();
        }
    }

    private void populateLifecycleMethods() {
        for (Component c : this.componentLookup.values()) {
            PrioritizedMethod em;
            if (c.methodsScanned) continue;
            c.methodsScanned = true;
            c.startMethods.clear();
            c.stopMethods.clear();
            c.destroyMethods.clear();
            List<Method> methods = ReflectionUtil.getAllMethods(c.instance.getClass(), Start.class);
            for (Method m : methods) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotation(Start.class).priority();
                c.startMethods.add(em);
            }
            methods = ReflectionUtil.getAllMethods(c.instance.getClass(), Stop.class);
            for (Method m : methods) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotation(Stop.class).priority();
                c.stopMethods.add(em);
            }
            methods = ReflectionUtil.getAllMethods(c.instance.getClass(), Destroy.class);
            for (Method m : methods) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotation(Destroy.class).priority();
                c.destroyMethods.add(em);
            }
        }
    }

    public void resetNonVolatile() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            if (c.nonVolatile) continue;
            this.componentLookup.remove(c.name);
        }
        if (trace) {
            log.trace((Object)("Reset volatile components.  Registry now contains " + this.componentLookup.keySet()));
        }
    }

    public void create() {
        if (!this.state.createAllowed()) {
            if (this.state.needToDestroyFailedCache()) {
                this.destroy();
            } else {
                return;
            }
        }
        try {
            this.internalCreate();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    public void start() {
        boolean createdInStart = false;
        if (!this.state.startAllowed()) {
            if (this.state.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.state.needCreateBeforeStart()) {
                this.create();
                createdInStart = true;
            } else {
                return;
            }
        }
        try {
            this.internalStart(createdInStart);
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.state.stopAllowed()) {
            return;
        }
        boolean failed = this.state == CacheStatus.FAILED;
        try {
            try {
                this.internalStop();
            }
            catch (Throwable t) {
                if (failed) {
                    log.warn((Object)"Attempted to stop() from FAILED state, but caught exception; try calling destroy()", t);
                }
                failed = true;
                this.handleLifecycleTransitionFailure(t);
                Object var4_3 = null;
                if (!failed) {
                    this.state = CacheStatus.STOPPED;
                }
            }
            Object var4_2 = null;
            if (!failed) {
                this.state = CacheStatus.STOPPED;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!failed) {
                this.state = CacheStatus.STOPPED;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.state.destroyAllowed()) {
            if (this.state.needStopBeforeDestroy()) {
                try {
                    this.stop();
                }
                catch (CacheException e) {
                    log.warn((Object)"Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", (Throwable)e);
                }
            } else {
                return;
            }
        }
        try {
            this.internalDestroy();
            Object var3_2 = null;
            this.state = CacheStatus.DESTROYED;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.state = CacheStatus.DESTROYED;
            throw throwable;
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) {
        this.state = CacheStatus.FAILED;
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalCreate() {
        this.state = CacheStatus.CREATING;
        this.resetNonVolatile();
        this.rewire();
        this.state = CacheStatus.CREATED;
    }

    private void internalStart(boolean createdInStart) throws CacheException, IllegalArgumentException {
        if (!createdInStart) {
            this.resetNonVolatile();
            this.rewire();
        }
        this.state = CacheStatus.STARTING;
        this.populateLifecycleMethods();
        ArrayList<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            startMethods.addAll(c.startMethods);
        }
        Collections.sort(startMethods);
        for (PrioritizedMethod em : startMethods) {
            em.invoke();
        }
        this.addShutdownHook();
        log.info((Object)("JBoss Cache version: " + Version.printVersion()));
        this.state = CacheStatus.STARTED;
    }

    private void addShutdownHook() {
        boolean registerShutdownHook;
        ArrayList<MBeanServer> al = MBeanServerFactory.findMBeanServer(null);
        boolean bl = registerShutdownHook = this.getConfiguration().getShutdownHookBehavior() == Configuration.ShutdownHookBehavior.DEFAULT && al.size() == 0 || this.getConfiguration().getShutdownHookBehavior() == Configuration.ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registering a shutdown hook.  Configured behavior = " + (Object)((Object)this.getConfiguration().getShutdownHookBehavior())));
            }
            this.shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ComponentRegistry.this.invokedFromShutdownHook = true;
                        ComponentRegistry.this.stop();
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        ComponentRegistry.this.invokedFromShutdownHook = false;
                        throw throwable;
                    }
                    ComponentRegistry.this.invokedFromShutdownHook = false;
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Not registering a shutdown hook.  Configured behavior = " + (Object)((Object)this.getConfiguration().getShutdownHookBehavior())));
        }
    }

    private void internalStop() {
        this.state = CacheStatus.STOPPING;
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        ArrayList<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            stopMethods.addAll(c.stopMethods);
        }
        Collections.sort(stopMethods);
        for (PrioritizedMethod em : stopMethods) {
            em.invoke();
        }
        this.state = CacheStatus.STOPPED;
    }

    private void internalDestroy() {
        this.state = CacheStatus.DESTROYING;
        this.resetNonVolatile();
        ArrayList<PrioritizedMethod> destroyMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            destroyMethods.addAll(c.destroyMethods);
        }
        Collections.sort(destroyMethods);
        for (PrioritizedMethod em : destroyMethods) {
            em.invoke();
        }
        this.state = CacheStatus.DESTROYED;
    }

    public boolean invocationsAllowed(boolean originLocal) {
        log.trace((Object)"Testing if invocations are allowed.");
        if (this.state.allowInvocations()) {
            return true;
        }
        if (originLocal) {
            return false;
        }
        log.trace((Object)"Is remotely originating.");
        if (this.state == CacheStatus.STARTING) {
            log.trace((Object)"Cache is starting; block.");
            try {
                this.blockUntilCacheStarts();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            log.warn((Object)"Received a remote call but the cache is not in STARTED state - ignoring call.");
        }
        return false;
    }

    private void blockUntilCacheStarts() throws InterruptedException, IllegalStateException {
        int pollFrequencyMS = 100;
        long startupWaitTime = this.getConfiguration().getStateRetrievalTimeout();
        long giveUpTime = System.currentTimeMillis() + startupWaitTime;
        while (System.currentTimeMillis() < giveUpTime && !this.state.allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
        if (!this.state.allowInvocations()) {
            throw new IllegalStateException("Cache not in STARTED state, even after waiting " + this.getConfiguration().getStateRetrievalTimeout() + " millis.");
        }
    }

    public Set<Component> getRegiteredComponents() {
        HashSet<Component> defensiveCopy = new HashSet<Component>(this.componentLookup.values());
        return Collections.unmodifiableSet(defensiveCopy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrioritizedMethod
    implements Comparable<PrioritizedMethod> {
        Method method;
        Component component;
        int priority;

        PrioritizedMethod() {
        }

        @Override
        public int compareTo(PrioritizedMethod o) {
            return this.priority < o.priority ? -1 : (this.priority == o.priority ? 0 : 1);
        }

        void invoke() {
            ReflectionUtil.invokeAccessibly(this.component.instance, this.method, null);
        }

        public String toString() {
            return "PrioritizedMethod{method=" + this.method + ", priority=" + this.priority + '}';
        }
    }

    public class Component {
        Object instance;
        String name;
        boolean methodsScanned;
        List<Method> injectionMethods = new ArrayList<Method>(2);
        List<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(2);
        List<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(2);
        List<PrioritizedMethod> destroyMethods = new ArrayList<PrioritizedMethod>(2);
        boolean nonVolatile;

        public String toString() {
            return "Component{instance=" + this.instance + ", name=" + this.name + ", nonVolatile=" + this.nonVolatile + '}';
        }

        public void injectDependencies() {
            for (Method m : this.injectionMethods) {
                ComponentRegistry.this.invokeInjectionMethod(this.instance, m);
            }
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getName() {
            return this.name;
        }
    }
}

