/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import org.jboss.cache.Fqn;
import org.jboss.cache.search.InvalidKeyException;
import org.jboss.cache.search.Transformer;

public class CacheEntityId {
    Fqn fqn;
    String key;
    String documentId;

    public CacheEntityId(String documentId) {
        if (documentId == null) {
            throw new NullPointerException("documentId is null");
        }
        this.documentId = documentId;
    }

    public CacheEntityId(Fqn fqn, String key) {
        if (fqn == null) {
            throw new NullPointerException("Fqn is null");
        }
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        this.fqn = fqn;
        this.key = key;
    }

    public Fqn getFqn() {
        if (this.fqn != null) {
            return this.fqn;
        }
        if (this.documentId != null) {
            this.fqn = Transformer.getFqn(this.documentId);
            return this.fqn;
        }
        if (this.documentId == null) {
            throw new IllegalArgumentException("docId is null");
        }
        throw new IllegalArgumentException("Fqn is null");
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.documentId != null) {
            this.key = Transformer.getKey(this.documentId);
            return this.key;
        }
        throw new IllegalArgumentException("At least key or documentId must be set to call this method");
    }

    public String getDocumentId() throws InvalidKeyException {
        if (this.key == null || this.fqn == null) {
            throw new IllegalArgumentException("Either your key or fqn is null. Please check again.");
        }
        return Transformer.generateId(this.fqn, this.key);
    }
}

