/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.search.CacheEntityId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheEntityLoader {
    Cache cache;
    private static final Log log = LogFactory.getLog(CacheEntityLoader.class);

    public CacheEntityLoader(Cache cache) {
        this.cache = cache;
    }

    public List<Object> load(List<CacheEntityId> ids) {
        if (ids == null) {
            throw new NullPointerException("ids are null");
        }
        ArrayList<Object> retVal = new ArrayList<Object>(ids.size());
        for (CacheEntityId id : ids) {
            retVal.add(this.cache.get(id.getFqn(), (Object)id.getKey()));
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Created list of return values. Size is  " + retVal.size()));
        }
        return retVal;
    }

    public Object load(CacheEntityId id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        return this.cache.get(id.getFqn(), (Object)id.getKey());
    }
}

