/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.QueryResultIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultIteratorImpl
implements QueryResultIterator {
    private int index = 0;
    private List<CacheEntityId> idList;
    private CacheEntityLoader entityLoader;
    private int lowerLimit = 0;
    private int upperLimit = 0;
    private int fetchSize = 0;
    private int bufferIndex = -1;
    private Object[] buffer;
    private static final Log log = LogFactory.getLog(QueryResultIteratorImpl.class);

    public QueryResultIteratorImpl(List<CacheEntityId> idList, CacheEntityLoader entityLoader, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchsize passed. Your fetchSize is less than 1");
        }
        this.idList = idList;
        System.out.println("idList size is " + idList.size());
        System.out.println("idList object 1 is " + idList.get(0));
        this.entityLoader = entityLoader;
        this.upperLimit = idList.size() - 1;
        this.fetchSize = fetchSize;
        this.buffer = new Object[this.fetchSize];
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index > this.idList.size() || index < 0) {
            throw new IndexOutOfBoundsException("The index you entered is either greater than the size of the list or negative");
        }
        this.index = index;
    }

    @Override
    public void first() {
        this.index = 0;
    }

    @Override
    public void last() {
        this.index = this.idList.size() - 1;
    }

    @Override
    public void afterFirst() {
        this.index = 1;
    }

    @Override
    public void beforeLast() {
        this.index = this.idList.size() - 2;
    }

    @Override
    public boolean isFirst() {
        return this.idList.get(this.index) == this.idList.get(0);
    }

    @Override
    public boolean isLast() {
        return this.index == this.idList.size() - 1;
    }

    @Override
    public boolean isAfterFirst() {
        return this.idList.get(this.index) == this.idList.get(1);
    }

    @Override
    public boolean isBeforeLast() {
        return this.idList.get(this.index) == this.idList.get(this.idList.size() - 2);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.index <= this.upperLimit;
    }

    @Override
    public Object next() {
        Object toReturn;
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Out of boundaries. There is no next");
        }
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index >= this.bufferIndex && this.index < this.bufferIndex + bufferSize) {
            int indexToReturn = this.index - this.bufferIndex;
            toReturn = this.buffer[indexToReturn];
        } else {
            toReturn = this.entityLoader.load(this.idList.get(this.index));
            Arrays.fill(this.buffer, null);
            this.buffer[0] = toReturn;
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                if (this.index + i > this.upperLimit) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Your current index + bufferSize exceeds the size of your number of hits");
                    break;
                }
                this.buffer[i] = toBuffer = this.entityLoader.load(this.idList.get(this.index + i));
            }
            this.bufferIndex = this.index;
        }
        ++this.index;
        return toReturn;
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= this.lowerLimit;
    }

    public Object previous() {
        Object toReturn;
        if (!this.hasPrevious()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no previous");
        }
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index <= this.bufferIndex && this.index >= this.bufferIndex + bufferSize) {
            int indexToReturn = this.bufferIndex - this.index;
            toReturn = this.buffer[indexToReturn];
        } else {
            toReturn = this.entityLoader.load(this.idList.get(this.index));
            Arrays.fill(this.buffer, null);
            this.buffer[0] = toReturn;
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                if (this.index - i < this.lowerLimit) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Your current index - bufferSize exceeds the size of your number of hits");
                    break;
                }
                this.buffer[i] = toBuffer = this.entityLoader.load(this.idList.get(this.index - i));
            }
            this.bufferIndex = this.index;
        }
        --this.index;
        return toReturn;
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }
}

