/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.InvalidKeyException;
import org.jboss.cache.search.NodeModifiedTransactionContext;

@CacheListener
public class SearchableCoreListener {
    private SearchFactoryImplementor searchFactory;
    private static final Log log = LogFactory.getLog(SearchableCoreListener.class);

    public SearchableCoreListener(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    @NodeModified
    public void updateLuceneIndexes(NodeModifiedEvent event) throws InvalidKeyException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"You have entered the SearchableListener");
        }
        if (!event.isPre()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"event.isPre is false. Going to start updating indexes");
            }
            switch (event.getModificationType()) {
                case PUT_MAP: 
                case PUT_DATA: {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"put() has been called on cache. Going to handle the data.");
                    }
                    this.handlePutData(event, this.searchFactory);
                    break;
                }
                case REMOVE_DATA: {
                    this.handleDeleteData(event, this.searchFactory);
                }
            }
        }
    }

    protected void handlePutData(NodeModifiedEvent event, SearchFactoryImplementor searchFactory) throws InvalidKeyException {
        Map dataMap = event.getData();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Called event.getData() and saved to a Map");
        }
        NodeModifiedTransactionContext ctx = new NodeModifiedTransactionContext(event);
        for (Object key : dataMap.keySet()) {
            CacheEntityId cacheEntityId = new CacheEntityId(event.getFqn(), (String)key);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Created new CacheEntityId");
            }
            String fqnString = cacheEntityId.getFqn().toString();
            String keyString = (String)key;
            searchFactory.getWorker().performWork(new Work(dataMap.get(key), (Serializable)((Object)cacheEntityId.getDocumentId()), WorkType.DELETE), (TransactionContext)ctx);
            searchFactory.getWorker().performWork(new Work(dataMap.get(key), (Serializable)((Object)cacheEntityId.getDocumentId()), WorkType.ADD), (TransactionContext)ctx);
            if (!log.isTraceEnabled()) continue;
            log.debug((Object)("Added your object into Lucene with Fqn " + fqnString + " and key " + keyString));
        }
    }

    protected void handleDeleteData(NodeModifiedEvent event, SearchFactoryImplementor searchFactory) throws InvalidKeyException {
        Map dataMap = event.getData();
        NodeModifiedTransactionContext ctx = new NodeModifiedTransactionContext(event);
        for (Object key : dataMap.keySet()) {
            CacheEntityId cacheEntityId = new CacheEntityId(event.getFqn(), (String)key);
            String fqnString = cacheEntityId.getFqn().toString();
            String keyString = (String)key;
            searchFactory.getWorker().performWork(new Work(dataMap.get(key), (Serializable)((Object)cacheEntityId.getDocumentId()), WorkType.DELETE), (TransactionContext)ctx);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Deleted your object from Lucene with Fqn " + fqnString + " and key " + keyString));
        }
    }
}

