/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.RPCManager;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.legacy.write.CreateNodeCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.remote.AnnounceBuddyPoolNameCommand;
import org.jboss.cache.commands.remote.AssignToBuddyGroupCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.commands.remote.DataGravitationCleanupCommand;
import org.jboss.cache.commands.remote.RemoveFromBuddyGroupCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsFactoryImpl
implements CommandsFactory {
    protected RPCManager rpcManager;
    protected DataContainer dataContainer;
    protected Notifier notifier;
    protected InterceptorChain invoker;
    protected BuddyManager buddyManager;
    protected TransactionTable transactionTable;
    protected CacheSPI cacheSpi;
    protected Configuration configuration;
    protected TransactionManager txManager;
    protected BuddyFqnTransformer buddyFqnTransformer;

    @Inject
    public void initialize(RPCManager rpc, DataContainer dataContainer, Notifier notifier, BuddyManager buddyManager, InterceptorChain invoker, TransactionTable transactionTable, CacheSPI cacheSpi, Configuration configuration, TransactionManager txManager, BuddyFqnTransformer buddyFqnTransformer) {
        this.rpcManager = rpc;
        this.dataContainer = dataContainer;
        this.notifier = notifier;
        this.buddyManager = buddyManager;
        this.invoker = invoker;
        this.transactionTable = transactionTable;
        this.cacheSpi = cacheSpi;
        this.configuration = configuration;
        this.txManager = txManager;
        this.buddyFqnTransformer = buddyFqnTransformer;
    }

    @Override
    public PutDataMapCommand buildPutDataMapCommand(GlobalTransaction gtx, Fqn fqn, Map data) {
        PutDataMapCommand cmd = new PutDataMapCommand(gtx, fqn, data);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(GlobalTransaction gtx, Fqn fqn, Object key, Object value) {
        PutKeyValueCommand cmd = new PutKeyValueCommand(gtx, fqn, key, value);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public PutForExternalReadCommand buildPutForExternalReadCommand(GlobalTransaction gtx, Fqn fqn, Object key, Object value) {
        PutForExternalReadCommand cmd = new PutForExternalReadCommand(gtx, fqn, key, value);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public ReplicateCommand buildReplicateCommand(ReplicableCommand command) {
        ReplicateCommand cmd = new ReplicateCommand(command);
        cmd.initialize(this.invoker);
        return cmd;
    }

    @Override
    public ReplicateCommand buildReplicateCommand(List<ReplicableCommand> modifications) {
        ReplicateCommand cmd = new ReplicateCommand(modifications);
        cmd.initialize(this.invoker);
        return cmd;
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, WriteCommand command, boolean onePhaseCommit) {
        return this.buildPrepareCommand(gtx, Collections.singletonList(command), this.rpcManager.getLocalAddress(), onePhaseCommit);
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, Address address, boolean onePhaseCommit) {
        return new PrepareCommand(gtx, modifications, address, onePhaseCommit);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return new CommitCommand(gtx);
    }

    @Override
    public DataGravitationCleanupCommand buildDataGravitationCleanupCommand(Fqn primaryFqn, Fqn backupFqn) {
        DataGravitationCleanupCommand command = new DataGravitationCleanupCommand(primaryFqn, backupFqn);
        command.initialize(this.buddyManager, this.invoker, this.transactionTable, this, this.dataContainer, this.buddyFqnTransformer);
        return command;
    }

    @Override
    public GravitateDataCommand buildGravitateDataCommand(Fqn fqn, Boolean searchSubtrees) {
        GravitateDataCommand command = new GravitateDataCommand(fqn, searchSubtrees, this.rpcManager.getLocalAddress());
        command.initialize(this.dataContainer, this.cacheSpi, this.buddyFqnTransformer);
        return command;
    }

    @Override
    public EvictCommand buildEvictFqnCommand(Fqn fqn) {
        EvictCommand command = new EvictCommand(fqn);
        command.initialize(this.notifier, this.dataContainer);
        return command;
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Fqn fqn) {
        InvalidateCommand command = new InvalidateCommand(fqn);
        command.initialize(this.cacheSpi, this.dataContainer, this.notifier);
        return command;
    }

    @Override
    public GetDataMapCommand buildGetDataMapCommand(Fqn fqn) {
        GetDataMapCommand command = new GetDataMapCommand(fqn);
        command.initialize(this.dataContainer);
        return command;
    }

    @Override
    public ExistsCommand buildExistsNodeCommand(Fqn fqn) {
        ExistsCommand command = new ExistsCommand(fqn);
        command.initialize(this.dataContainer);
        return command;
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Fqn fqn, Object key, boolean sendNodeEvent) {
        GetKeyValueCommand command = new GetKeyValueCommand(fqn, key, sendNodeEvent);
        command.initialize(this.dataContainer, this.notifier);
        return command;
    }

    @Override
    public GetNodeCommand buildGetNodeCommand(Fqn fqn) {
        GetNodeCommand command = new GetNodeCommand(fqn);
        command.initialize(this.dataContainer);
        return command;
    }

    @Override
    public GetKeysCommand buildGetKeysCommand(Fqn fqn) {
        GetKeysCommand command = new GetKeysCommand(fqn);
        command.initialize(this.dataContainer);
        return command;
    }

    @Override
    public GetChildrenNamesCommand buildGetChildrenNamesCommand(Fqn fqn) {
        GetChildrenNamesCommand command = new GetChildrenNamesCommand(fqn);
        command.initialize(this.dataContainer);
        return command;
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return new RollbackCommand(gtx);
    }

    @Override
    public OptimisticPrepareCommand buildOptimisticPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, Address address, boolean onePhaseCommit) {
        return new OptimisticPrepareCommand(gtx, modifications, address, onePhaseCommit);
    }

    @Override
    public AnnounceBuddyPoolNameCommand buildAnnounceBuddyPoolNameCommand(Address address, String buddyPoolName) {
        AnnounceBuddyPoolNameCommand command = new AnnounceBuddyPoolNameCommand(address, buddyPoolName);
        command.initialize(this.buddyManager);
        return command;
    }

    @Override
    public RemoveFromBuddyGroupCommand buildRemoveFromBuddyGroupCommand(String groupName) {
        RemoveFromBuddyGroupCommand command = new RemoveFromBuddyGroupCommand(groupName);
        command.initialize(this.buddyManager);
        return command;
    }

    @Override
    public AssignToBuddyGroupCommand buildAssignToBuddyGroupCommand(BuddyGroup group, Map<Fqn, byte[]> state) {
        AssignToBuddyGroupCommand command = new AssignToBuddyGroupCommand(group, state);
        command.initialize(this.buddyManager);
        return command;
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Boolean searchBackupSubtrees, DataCommand dataCommand) {
        ClusteredGetCommand command = new ClusteredGetCommand(searchBackupSubtrees, dataCommand);
        command.initialize(this.dataContainer, this.invoker);
        return command;
    }

    @Override
    public RemoveNodeCommand buildRemoveNodeCommand(GlobalTransaction gtx, Fqn fqn) {
        RemoveNodeCommand cmd = new RemoveNodeCommand(gtx, fqn);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public ClearDataCommand buildClearDataCommand(GlobalTransaction gtx, Fqn fqn) {
        ClearDataCommand cmd = new ClearDataCommand(gtx, fqn);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public RemoveKeyCommand buildRemoveKeyCommand(GlobalTransaction tx, Fqn fqn, Object key) {
        RemoveKeyCommand cmd = new RemoveKeyCommand(tx, fqn, key);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public MoveCommand buildMoveCommand(Fqn from, Fqn to) {
        MoveCommand cmd = new MoveCommand(from, to);
        cmd.initialize(this.notifier, this.dataContainer);
        return cmd;
    }

    @Override
    public CreateNodeCommand buildCreateNodeCommand(Fqn fqn) {
        throw new UnsupportedOperationException("Not supported in MVCC!");
    }

    @Override
    public ReplicableCommand fromStream(int id, Object[] parameters) {
        ReplicableCommand command;
        switch (id) {
            case 16: {
                ExistsCommand result = new ExistsCommand();
                result.initialize(this.dataContainer);
                command = result;
                break;
            }
            case 23: {
                GetChildrenNamesCommand returnValue = new GetChildrenNamesCommand();
                returnValue.initialize(this.dataContainer);
                command = returnValue;
                break;
            }
            case 24: {
                GetDataMapCommand returnValue = new GetDataMapCommand();
                returnValue.initialize(this.dataContainer);
                command = returnValue;
                break;
            }
            case 25: {
                GetKeysCommand returnValue = new GetKeysCommand();
                returnValue.initialize(this.dataContainer);
                command = returnValue;
                break;
            }
            case 26: {
                GetKeyValueCommand returnValue = new GetKeyValueCommand();
                returnValue.initialize(this.dataContainer, this.notifier);
                command = returnValue;
                break;
            }
            case 31: {
                GetNodeCommand returnValue = new GetNodeCommand();
                returnValue.initialize(this.dataContainer);
                command = returnValue;
                break;
            }
            case 36: {
                MoveCommand returnValue = new MoveCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 1: 
            case 2: 
            case 37: 
            case 38: {
                PutDataMapCommand returnValue = new PutDataMapCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 3: 
            case 39: {
                PutKeyValueCommand returnValue = new PutKeyValueCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 45: 
            case 46: {
                PutForExternalReadCommand returnValue = new PutForExternalReadCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 7: 
            case 42: {
                ClearDataCommand returnValue = new ClearDataCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 6: 
            case 41: {
                RemoveKeyCommand returnValue = new RemoveKeyCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 5: 
            case 40: {
                RemoveNodeCommand returnValue = new RemoveNodeCommand();
                returnValue.initialize(this.notifier, this.dataContainer);
                command = returnValue;
                break;
            }
            case 48: {
                throw new UnsupportedOperationException("CreateNodeCommand is not supported in MVCC!");
            }
            case 10: {
                command = new PrepareCommand();
                break;
            }
            case 18: {
                command = new OptimisticPrepareCommand();
                break;
            }
            case 11: {
                command = new CommitCommand();
                break;
            }
            case 12: {
                command = new RollbackCommand();
                break;
            }
            case 13: 
            case 14: {
                ReplicateCommand returnValue = new ReplicateCommand();
                returnValue.initialize(this.invoker);
                command = returnValue;
                break;
            }
            case 47: {
                InvalidateCommand returnValue = new InvalidateCommand();
                returnValue.initialize(this.cacheSpi, this.dataContainer, this.notifier);
                command = returnValue;
                break;
            }
            case 22: {
                ClusteredGetCommand returnValue = new ClusteredGetCommand();
                returnValue.initialize(this.dataContainer, this.invoker);
                command = returnValue;
                break;
            }
            case 28: {
                AnnounceBuddyPoolNameCommand returnValue = new AnnounceBuddyPoolNameCommand();
                returnValue.initialize(this.buddyManager);
                command = returnValue;
                break;
            }
            case 29: {
                AssignToBuddyGroupCommand returnValue = new AssignToBuddyGroupCommand();
                returnValue.initialize(this.buddyManager);
                command = returnValue;
                break;
            }
            case 30: {
                RemoveFromBuddyGroupCommand returnValue = new RemoveFromBuddyGroupCommand();
                returnValue.initialize(this.buddyManager);
                command = returnValue;
                break;
            }
            case 34: {
                DataGravitationCleanupCommand returnValue = new DataGravitationCleanupCommand();
                returnValue.initialize(this.buddyManager, this.invoker, this.transactionTable, this, this.dataContainer, this.buddyFqnTransformer);
                command = returnValue;
                break;
            }
            case 35: {
                GravitateDataCommand returnValue = new GravitateDataCommand(this.rpcManager.getLocalAddress());
                returnValue.initialize(this.dataContainer, this.cacheSpi, this.buddyFqnTransformer);
                command = returnValue;
                break;
            }
            default: {
                throw new CacheException("Unknown command id " + id + "!");
            }
        }
        command.setParameters(id, parameters);
        return command;
    }
}

