/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.NotSerializableException;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.remote.AnnounceBuddyPoolNameCommand;
import org.jboss.cache.commands.remote.AssignToBuddyGroupCommand;
import org.jboss.cache.commands.remote.RemoveFromBuddyGroupCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.util.concurrent.BoundedExecutors;
import org.jboss.cache.util.concurrent.WithinThreadExecutor;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    protected InvocationContextContainer invocationContextContainer;
    protected InterceptorChain interceptorChain;
    protected ComponentRegistry componentRegistry;
    protected boolean trace;
    private ExecutorService replicationProcessor;
    private AtomicInteger replicationProcessorCount;
    private boolean asyncSerial;

    public CommandAwareRpcDispatcher() {
    }

    public CommandAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object serverObj, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry) {
        super(channel, l, l2, serverObj);
        this.invocationContextContainer = container;
        this.componentRegistry = componentRegistry;
        this.interceptorChain = interceptorChain;
        this.trace = this.log.isTraceEnabled();
        Configuration c = componentRegistry.getComponent(Configuration.class);
        this.replicationProcessor = c.getRuntimeConfig().getAsyncSerializationExecutor();
        if (c.getCacheMode().isSynchronous() || this.replicationProcessor == null && c.getSerializationExecutorPoolSize() < 1 || this.requireSyncMarshalling(c)) {
            this.replicationProcessor = new WithinThreadExecutor();
            this.asyncSerial = false;
        } else {
            this.asyncSerial = true;
            if (this.replicationProcessor == null) {
                this.replicationProcessorCount = new AtomicInteger(0);
                this.replicationProcessor = BoundedExecutors.newFixedThreadPool(c.isUseReplQueue() ? 1 : c.getSerializationExecutorPoolSize(), new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        return new Thread(r, "AsyncReplicationProcessor-" + CommandAwareRpcDispatcher.this.replicationProcessorCount.incrementAndGet());
                    }
                }, c.getSerializationExecutorQueueSize());
            }
        }
    }

    private boolean requireSyncMarshalling(Configuration c) {
        boolean enforceSerialMarshalling;
        boolean bl = enforceSerialMarshalling = c.getNodeLockingScheme().equals((Object)Configuration.NodeLockingScheme.OPTIMISTIC) && !c.getCacheMode().isInvalidation();
        if (enforceSerialMarshalling) {
            if (c.getSerializationExecutorPoolSize() > 1 && this.log.isWarnEnabled()) {
                this.log.warn((Object)"Async optimistic caches do not support serialization pools.");
            }
            if (this.trace) {
                this.log.trace((Object)"Disbaling serial marshalling for opt async cache");
            }
        }
        return enforceSerialMarshalling;
    }

    public void stop() {
        this.replicationProcessor.shutdownNow();
        try {
            this.replicationProcessor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.stop();
    }

    protected boolean isValid(Message req) {
        if (this.server_obj == null) {
            this.log.error((Object)"no method handler is registered. Discarding request.");
            return false;
        }
        if (req == null || req.getLength() == 0) {
            this.log.error((Object)"message or message buffer is null");
            return false;
        }
        return true;
    }

    public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean anycasting, boolean oob, RspFilter filter) throws NotSerializableException, ExecutionException, InterruptedException {
        if (dests != null && dests.isEmpty()) {
            if (this.trace) {
                this.log.trace((Object)"Destination list is empty: no need to send message");
            }
            return new RspList();
        }
        if (this.trace) {
            this.log.trace((Object)new StringBuilder("dests=").append(dests).append(", command=").append(command).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        ReplicationTask replicationTask = new ReplicationTask(command, oob, dests, mode, timeout, anycasting, filter);
        Future<RspList> response = this.replicationProcessor.submit(replicationTask);
        if (this.asyncSerial) {
            return null;
        }
        RspList retval = response.get();
        if (retval.isEmpty() || this.containsOnlyNulls(retval)) {
            return null;
        }
        return retval;
    }

    private boolean containsOnlyNulls(RspList l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            try {
                return this.executeCommand((ReplicableCommand)this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength()), req);
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace((Object)"Problems invoking command.", x);
                }
                return x;
            }
        }
        return null;
    }

    protected Object executeCommand(ReplicableCommand cmd, Message req) throws Throwable {
        if (cmd == null) {
            throw new NullPointerException("Unable to execute a null command!  Message was " + req);
        }
        if (this.trace) {
            this.log.trace((Object)("Executing command: " + cmd + " [sender=" + req.getSrc() + "]"));
        }
        if (cmd instanceof VisitableCommand) {
            InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
            ctx.setOriginLocal(false);
            if (!this.componentRegistry.invocationsAllowed(false)) {
                return null;
            }
            return this.interceptorChain.invoke(ctx, (VisitableCommand)cmd);
        }
        if (this.trace) {
            this.log.trace((Object)"This is a non-visitable command - so performing directly and not via the invoker.");
        }
        if (!(cmd instanceof AnnounceBuddyPoolNameCommand || cmd instanceof AssignToBuddyGroupCommand || cmd instanceof RemoveFromBuddyGroupCommand || this.componentRegistry.invocationsAllowed(false))) {
            return null;
        }
        return cmd.perform(null);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplicationTask
    implements Callable<RspList> {
        private ReplicableCommand command;
        private boolean oob;
        private Vector<Address> dests;
        private int mode;
        private long timeout;
        private boolean anycasting;
        private RspFilter filter;

        private ReplicationTask(ReplicableCommand command, boolean oob, Vector<Address> dests, int mode, long timeout, boolean anycasting, RspFilter filter) {
            this.command = command;
            this.oob = oob;
            this.dests = dests;
            this.mode = mode;
            this.timeout = timeout;
            this.anycasting = anycasting;
            this.filter = filter;
        }

        @Override
        public RspList call() throws Exception {
            Buffer buf;
            try {
                buf = CommandAwareRpcDispatcher.this.req_marshaller.objectToBuffer((Object)this.command);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure to marshal argument(s)", e);
            }
            Message msg = new Message();
            msg.setBuffer(buf);
            if (this.oob) {
                msg.setFlag((byte)1);
            }
            RspList retval = CommandAwareRpcDispatcher.this.castMessage(this.dests, msg, this.mode, this.timeout, this.anycasting, this.filter);
            if (CommandAwareRpcDispatcher.this.trace) {
                CommandAwareRpcDispatcher.this.log.trace((Object)("responses: " + retval));
            }
            if (retval == null) {
                throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + this.command.getClass().getSimpleName() + " not being serializable.");
            }
            return retval;
        }
    }
}

