/*
 * JBoss, Home of Professional Open Source
 * Copyright ${year}, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.search;

import org.apache.lucene.search.Query;
import org.jboss.cache.Cache;

/**
 * This will be the most used interface in JBossCache searchable. It extends Cache and therefore will have
 * the standard get(), put() and remove() methods. The additional method is the createQuery method which people
 * will use to build their Hibernate Search queries from a luceneQuery - Hibernate Search users will be very familiar
 * with this.
 *
 * @author Navin Surtani (<a href="mailto:nsurtani@redhat.com">nsurtani@redhat.com</a>)
 *         <p/>
 */
public interface SearchableCache<K, V> extends Cache<K, V>
{


   /**
    * Creates a CacheQuery from a lucene query and a class array.
    *
    * @param classes     - array of classes to be searched from.
    * @param luceneQuery - from {@link org.apache.lucene.search.Query}
    * @return a CacheQuery instance from which the user can get a list/iterator object.
    */
   CacheQuery createQuery(Query luceneQuery, Class... classes);
}
