/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.LazyQueryResultIterator;
import org.jboss.cache.search.SearchableCache;
import org.jboss.cache.search.SearchableCacheFactory;
import org.jboss.cache.search.helper.IndexCleanUp;
import org.jboss.cache.search.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LazyQueryResultIteratorTest {
    SearchableCache searchableCache;
    QueryParser parser = null;
    Query luceneQuery = null;
    CacheQuery cacheQuery = null;
    LazyQueryResultIterator iterator = null;
    int fetchSize = 1;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    Person person5;
    Person person6;
    Person person7;
    Person person8;
    Person person9;
    Person person10;
    StringBuilder builder;

    @BeforeTest
    public void setUpBeforeTest() throws ParseException {
        Cache coreCache = new DefaultCacheFactory().createCache();
        this.searchableCache = new SearchableCacheFactory().createSearchableCache(coreCache, new Class[]{Person.class});
        this.person1 = new Person();
        this.person2 = new Person();
        this.person3 = new Person();
        this.person4 = new Person();
        this.person5 = new Person();
        this.person6 = new Person();
        this.person7 = new Person();
        this.person8 = new Person();
        this.person9 = new Person();
        this.person10 = new Person();
        this.person1.setBlurb("cat");
        this.person2.setBlurb("cat");
        this.person3.setBlurb("cat");
        this.person4.setBlurb("cat");
        this.person5.setBlurb("cat");
        this.person6.setBlurb("cat");
        this.person7.setBlurb("cat");
        this.person8.setBlurb("cat");
        this.person9.setBlurb("cat");
        this.person10.setBlurb("cat");
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key1", (Object)this.person1);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key2", (Object)this.person2);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key3", (Object)this.person3);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key4", (Object)this.person4);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key5", (Object)this.person5);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key6", (Object)this.person6);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key7", (Object)this.person7);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key8", (Object)this.person8);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key9", (Object)this.person9);
        this.searchableCache.put(Fqn.fromString((String)"/a"), (Object)"key10", (Object)this.person10);
    }

    @AfterTest
    public void tearDownAfterTest() {
        IndexCleanUp.cleanUpIndexes();
    }

    @BeforeMethod
    public void setUp() throws ParseException {
        this.parser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.parser.parse("cat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.iterator = (LazyQueryResultIterator)this.cacheQuery.lazyIterator();
    }

    @AfterMethod
    public void tearDown() {
        this.iterator = null;
        this.parser = null;
        this.luceneQuery = null;
        this.cacheQuery = null;
    }

    public void testJumpToResult() throws IndexOutOfBoundsException {
        this.iterator.jumpToResult(0);
        assert (this.iterator.isFirst());
        this.iterator.jumpToResult(1);
        assert (this.iterator.isAfterFirst());
        this.iterator.jumpToResult(9);
        assert (this.iterator.isLast());
        this.iterator.jumpToResult(8);
        assert (this.iterator.isBeforeLast());
    }

    public void testFirst() {
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        Object next = this.iterator.next();
        assert (next == this.person1);
        assert (!this.iterator.isFirst());
        this.iterator.first();
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        next = this.iterator.next();
        assert (next == this.person1);
        assert (!this.iterator.isFirst());
    }

    public void testLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.first();
        assert (!this.iterator.isLast());
    }

    public void testAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        Object previous = this.iterator.previous();
        assert (previous == this.person2);
        assert (!this.iterator.isAfterFirst());
    }

    public void testBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        Object next = this.iterator.next();
        assert (next == this.person9);
        assert (!this.iterator.isBeforeLast());
    }

    public void testIsFirst() {
        this.iterator.first();
        assert (this.iterator.isFirst());
        this.iterator.next();
        assert (!this.iterator.isFirst());
    }

    public void testIsLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.previous();
        assert (!this.iterator.isLast());
    }

    public void testIsAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        this.iterator.previous();
        assert (!this.iterator.isAfterFirst());
    }

    public void testIsBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
    }

    public void testNextAndHasNext() {
        this.iterator.first();
        this.builder = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            this.builder.delete(0, 4);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.searchableCache.get("/a", (Object)keyString);
            assert (this.iterator.hasNext());
            Object next = this.iterator.next();
            assert (expectedValue == next);
        }
        assert (!this.iterator.hasNext());
    }

    public void testPreviousAndHasPrevious() {
        this.iterator.last();
        this.builder = new StringBuilder();
        for (int i = 10; i >= 1; --i) {
            this.builder.delete(0, 5);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.searchableCache.get("/a", (Object)keyString);
            assert (this.iterator.hasPrevious());
            Object previous = this.iterator.previous();
            assert (expectedValue == previous);
        }
        assert (!this.iterator.hasPrevious());
    }

    public void testNextIndex() {
        this.iterator.first();
        assert (this.iterator.nextIndex() == 1);
        this.iterator.last();
        assert (this.iterator.nextIndex() == 10);
    }

    public void testPreviousIndex() {
        this.iterator.first();
        assert (this.iterator.previousIndex() == -1);
        this.iterator.last();
        assert (this.iterator.previousIndex() == 8);
    }
}

