/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.QueryResultIterator;
import org.jboss.cache.search.QueryResultIteratorImpl;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class QueryResultIteratorImplTest {
    List<CacheEntityId> ids;
    Map<CacheEntityId, Object> dummyResults;
    QueryResultIterator iterator;
    int fetchSize = 1;

    @BeforeMethod
    public void setUp() {
        this.ids = new ArrayList<CacheEntityId>();
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/a"), "key1"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/b"), "key2"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/c"), "key3"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/d"), "key4"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/e"), "key5"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/f"), "key6"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/g"), "key7"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/h"), "key8"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/i"), "key9"));
        this.ids.add(new CacheEntityId(Fqn.fromString((String)"/j"), "key10"));
        this.dummyResults = new HashMap<CacheEntityId, Object>();
        int counter = 0;
        for (CacheEntityId id : this.ids) {
            this.dummyResults.put(id, "Result number " + counter++);
        }
        DummyEntityLoader dummyLoader = new DummyEntityLoader(this.ids, this.dummyResults);
        this.iterator = new QueryResultIteratorImpl(this.ids, (CacheEntityLoader)dummyLoader, this.fetchSize);
    }

    @AfterMethod
    public void tearDown() {
        this.ids = null;
        this.dummyResults = null;
        this.iterator = null;
    }

    public void testJumpToResult() throws IndexOutOfBoundsException {
        this.iterator.jumpToResult(0);
        assert (this.iterator.isFirst());
        this.iterator.jumpToResult(1);
        assert (this.iterator.isAfterFirst());
        this.iterator.jumpToResult(this.ids.size() - 1);
        assert (this.iterator.isLast());
        this.iterator.jumpToResult(this.ids.size() - 2);
        assert (this.iterator.isBeforeLast());
    }

    public void testFirst() {
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        Object next = this.iterator.next();
        assert (next == this.dummyResults.get(this.ids.get(0)));
        assert (!this.iterator.isFirst());
        this.iterator.first();
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        next = this.iterator.next();
        assert (next == this.dummyResults.get(this.ids.get(0)));
        assert (!this.iterator.isFirst());
    }

    public void testLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        Object next = this.iterator.next();
        int size = this.ids.size();
        assert (next == this.dummyResults.get(this.ids.get(size - 1)));
        assert (!this.iterator.isLast());
    }

    public void testAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        Object previous = this.iterator.previous();
        assert (previous == this.dummyResults.get(this.ids.get(1)));
        assert (!this.iterator.isAfterFirst());
    }

    public void testBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        Object next = this.iterator.next();
        int size = this.ids.size();
        assert (next == this.dummyResults.get(this.ids.get(size - 2)));
        assert (!this.iterator.isBeforeLast());
    }

    public void testIsFirst() {
        this.iterator.first();
        assert (this.iterator.isFirst());
        this.iterator.next();
        assert (!this.iterator.isFirst());
    }

    public void testIsLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.previous();
        assert (!this.iterator.isLast());
    }

    public void testIsAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        this.iterator.previous();
        assert (!this.iterator.isAfterFirst());
    }

    public void testIsBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
    }

    public void testNextAndHasNext() {
        this.iterator.first();
        for (int i = 0; i < this.ids.size(); ++i) {
            System.out.println("Loop number count: - " + (i + 1));
            Object expectedValue = this.dummyResults.get(this.ids.get(i));
            assert (this.iterator.hasNext());
            assert (expectedValue == this.iterator.next());
        }
        assert (!this.iterator.hasNext());
    }

    public void testPreviousAndHasPrevious() {
        this.iterator.last();
        for (int i = this.ids.size() - 1; i >= 0; --i) {
            Object expectedValue = this.dummyResults.get(this.ids.get(i));
            assert (this.iterator.hasPrevious());
            assert (expectedValue == this.iterator.previous());
        }
        assert (!this.iterator.hasPrevious());
    }

    public void testNextIndex() {
        this.iterator.first();
        assert (this.iterator.nextIndex() == 1);
        this.iterator.last();
        assert (this.iterator.nextIndex() == this.ids.size());
    }

    public void testPreviousIndex() {
        this.iterator.first();
        assert (this.iterator.previousIndex() == -1);
        this.iterator.last();
        assert (this.iterator.previousIndex() == this.ids.size() - 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyEntityLoader
    extends CacheEntityLoader {
        private List<CacheEntityId> allKnownIds;
        private Map<CacheEntityId, Object> dummyValues;

        public DummyEntityLoader(List<CacheEntityId> allKnownIds, Map<CacheEntityId, Object> dummyValues) {
            super(null);
            this.allKnownIds = allKnownIds;
            this.dummyValues = dummyValues;
        }

        public List<Object> load(List<CacheEntityId> ids) {
            ArrayList<Object> resultsToReturn = new ArrayList<Object>(ids.size());
            for (CacheEntityId id : ids) {
                resultsToReturn.add(this.dummyValues.get(id));
            }
            return resultsToReturn;
        }

        public Object load(CacheEntityId id) {
            return this.dummyValues.get(id);
        }
    }
}

