/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import org.jboss.cache.Fqn;
import org.jboss.cache.search.InvalidFqnException;
import org.jboss.cache.search.InvalidKeyException;
import org.jboss.cache.search.Transformer;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class TransformerTest {
    public void testGenerateId() throws InvalidKeyException {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        String key = "key";
        String generatedId = Transformer.generateId((Fqn)fqn, (String)key);
        assert (generatedId.contentEquals("Fqn=[/a/b/c]Key=[key]"));
        assert (!generatedId.contentEquals("/ab/c/d"));
    }

    public void testGetFqn() {
        Fqn fqn = Transformer.getFqn((String)"Fqn=[/cat/dog/person]Key=[key]");
        Fqn expectedFqn = Fqn.fromString((String)"/cat/dog/person");
        assert (fqn.equals((Object)expectedFqn));
        expectedFqn = Fqn.fromString((String)"/dog/cat/person");
        assert (!fqn.equals((Object)expectedFqn));
    }

    public void testGetKey() {
        String key = Transformer.getKey((String)"Fqn=[/a/b/c]Key=[thisIsMyKey]");
        assert (key.contentEquals("thisIsMyKey"));
        assert (!key.contentEquals("thisIsNotMyKey"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testGetKeyWithNull() {
        Transformer.getKey(null);
    }

    @Test(expectedExceptions={InvalidFqnException.class})
    public void testGenerateIdWithHackedString() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/Fqn=[/a/b/c"), (String)"x");
    }

    @Test(expectedExceptions={InvalidFqnException.class})
    public void testGenerateIdWithHackedFqn() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/Fqn=[/a/b/c"), (String)"x");
    }

    @Test(expectedExceptions={InvalidFqnException.class})
    public void testGenerateIdWithHackedFqn2() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/]Key=[/a/b/c"), (String)"x");
    }

    @Test(expectedExceptions={InvalidKeyException.class})
    public void testGenerateIdWithHackedKey() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/a/b/c"), (String)"]Key=[");
    }

    @Test(expectedExceptions={InvalidKeyException.class})
    public void testGenerateIdWithHackedKey2() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/a/b/c"), (String)"Fqn=[");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testGenerateIdWithNullKey() throws InvalidKeyException {
        Transformer.generateId((Fqn)Fqn.fromString((String)"/a/b/c"), null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testGenerateIdWithNullFqn() throws InvalidKeyException {
        Transformer.generateId(null, (String)"x");
    }
}

