/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search.blackbox;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.SearchableCache;
import org.jboss.cache.search.SearchableCacheFactory;
import org.jboss.cache.search.helper.IndexCleanUp;
import org.jboss.cache.search.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ClusteredCacheTest {
    Cache cache1;
    Cache cache2;
    SearchableCache searchableCache1;
    SearchableCache searchableCache2;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    List found;
    String key1 = "Navin";
    String key2 = "BigGoat";
    String key3 = "MiniGoat";
    private static final Log log = LogFactory.getLog(Person.class);

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        Configuration cacheCfg = new Configuration();
        cacheCfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cacheCfg.setFetchInMemoryState(false);
        this.cache1 = new DefaultCacheFactory().createCache(cacheCfg.clone());
        this.searchableCache1 = new SearchableCacheFactory().createSearchableCache(this.cache1, new Class[]{Person.class});
        this.cache2 = new DefaultCacheFactory().createCache(cacheCfg.clone());
        this.searchableCache2 = new SearchableCacheFactory().createSearchableCache(this.cache2, new Class[]{Person.class});
        long giveUpTime = System.currentTimeMillis() + 60000L;
        boolean wait = true;
        while (wait && System.currentTimeMillis() < giveUpTime) {
            wait = this.cache1.getMembers().size() != 2 || this.cache2.getMembers().size() != 2;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (wait) {
            throw new RuntimeException("Unable to initialise cluster!");
        }
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.searchableCache1.put(Fqn.fromString((String)"/a/b/c"), (Object)this.key1, (Object)this.person1);
        this.searchableCache1.put(Fqn.fromString((String)"/a/b/d"), (Object)this.key2, (Object)this.person2);
        this.searchableCache1.put(Fqn.fromString((String)"/a/b/c"), (Object)this.key3, (Object)this.person3);
    }

    @AfterMethod
    public void tearDown() {
        if (this.searchableCache1 != null) {
            this.searchableCache1.stop();
        }
        if (this.searchableCache2 != null) {
            this.searchableCache2.stop();
        }
        IndexCleanUp.cleanUpIndexes();
    }

    public void testSimple() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        if (this.found.get(0) == null) {
            Person p1;
            if (log.isTraceEnabled()) {
                log.warn((Object)"found.get(0) is null");
            }
            if ((p1 = (Person)this.searchableCache2.get("/a/b/c", (Object)this.key1)) == null) {
                if (log.isTraceEnabled()) {
                    log.warn((Object)"Person p1 is null in sc2 and cannot actually see the data of person1 in sc1");
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("p1 name is  " + p1.getName()));
            }
        }
        assert (this.found.get(0).equals(this.person1));
    }

    public void testModified() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.searchableCache1.put(Fqn.fromString((String)"/a/b/c/"), (Object)"Navin", (Object)this.person1);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        System.out.println("found.size() is " + this.found.size());
        assert (this.found.size() == 2) : "Size of list should be 2";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (!this.found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.searchableCache1.put(Fqn.fromString((String)"/r/a/m/"), (Object)"Ram", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 3) : "Size of list should be 3";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (this.found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3)) : "This should still contain object person3";
        this.searchableCache1.remove(Fqn.fromString((String)"/a/b/c/"), (Object)this.key3);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = this.searchableCache2.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.contains(this.person2));
        assert (!this.found.contains(this.person3)) : "The search should not return person3";
    }
}

