/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search.blackbox;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.QueryResultIterator;
import org.jboss.cache.search.SearchableCache;
import org.jboss.cache.search.SearchableCacheFactory;
import org.jboss.cache.search.helper.IndexCleanUp;
import org.jboss.cache.search.test.Person;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class LocalCacheProfilerTest {
    SearchableCache searchableCache;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    Person person5;
    Person person6;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    List found;
    String key1 = "Navin";
    String key2 = "BigGoat";
    String key3 = "MiniGoat";

    @BeforeTest
    public void setUp() {
        Cache coreCache = new DefaultCacheFactory().createCache();
        this.searchableCache = new SearchableCacheFactory().createSearchableCache(coreCache, new Class[]{Person.class});
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person5 = new Person();
        this.person5.setName("Smelly Cat");
        this.person5.setBlurb("Eats fish");
        this.searchableCache.put(Fqn.fromString((String)"/a/b/c"), (Object)this.key1, (Object)this.person1);
        this.searchableCache.put(Fqn.fromString((String)"/a/b/d"), (Object)this.key2, (Object)this.person2);
        this.searchableCache.put(Fqn.fromString((String)"/a/b/c"), (Object)this.key3, (Object)this.person3);
    }

    @AfterTest
    public void tearDown() {
        if (this.searchableCache != null) {
            this.searchableCache.stop();
        }
        IndexCleanUp.cleanUpIndexes();
    }

    @Test(invocationCount=200000, enabled=false)
    public void testSimple() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
    }

    @Test(invocationCount=200000, enabled=false)
    public void testSimpleIterator() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        QueryResultIterator found = this.cacheQuery.iterator();
        assert (found.isFirst());
        assert (found.isLast());
    }

    @Test(invocationCount=200000, enabled=false)
    public void testMultipleResults() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.get(0) == this.person2);
        assert (this.found.get(1) == this.person3);
    }

    @Test(invocationCount=200000, enabled=false)
    public void testModified() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.searchableCache.put(Fqn.fromString((String)"/a/b/c/"), (Object)this.key1, (Object)this.person1);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
    }

    @Test(invocationCount=200000, enabled=false)
    public void testAdded() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2) : "Size of list should be 2";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (!this.found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.searchableCache.put(Fqn.fromString((String)"/r/a/m/"), (Object)"Ram", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 3) : "Size of list should be 3";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (this.found.contains(this.person4)) : "This should now contain object person4";
    }

    @Test(invocationCount=200000, enabled=false)
    public void testRemoved() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3)) : "This should still contain object person3";
        this.searchableCache.remove(Fqn.fromString((String)"/a/b/c/"), (Object)this.key3);
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.contains(this.person2));
        assert (!this.found.contains(this.person3)) : "The search should not return person3";
    }

    @Test(invocationCount=200000, enabled=false)
    public void testSetSort() throws ParseException {
        this.person2.setAge(35);
        this.person3.setAge(12);
        Sort sort = new Sort("age");
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        this.cacheQuery.setSort(sort);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.get(0).equals(this.person2));
        assert (this.found.get(1).equals(this.person3));
    }

    @Test(invocationCount=200000, enabled=false)
    public void testSetFilter() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("goat");
        this.cacheQuery = this.searchableCache.createQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        this.cacheQuery.setFilter((Filter)filter);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
    }
}

