/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.HibernateException;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.CachingWrapperFilter;
import org.hibernate.search.filter.ChainedFilter;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.query.QueryHits;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.FilterCacheModeTypeHelper;
import org.hibernate.transform.ResultTransformer;
import org.jboss.cache.Cache;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.IndexSearcherCloser;
import org.jboss.cache.search.LazyQueryResultIterator;
import org.jboss.cache.search.QueryResultIterator;
import org.jboss.cache.search.QueryResultIteratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheQueryImpl
implements CacheQuery {
    private Class[] classes;
    private Sort sort;
    private Filter filter;
    private Map<String, FullTextFilterImpl> filterDefinitions;
    private SearchFactoryImplementor searchFactory;
    private Integer firstResult;
    private Integer resultSize;
    private Integer maxResults;
    private static final Log log = LogFactory.getLog(CacheQueryImpl.class);
    private boolean needClassFilterClause;
    private Query luceneQuery;
    private String[] indexProjection;
    private ResultTransformer resultTransformer;
    CacheEntityLoader entityLoader;
    private Set<Class<?>> targetedEntities;
    private Set<Class<?>> classesAndSubclasses;
    private Set<String> idFieldNames;
    private boolean allowFieldSelectionInProjection = true;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryImplementor searchFactory, Cache cache, Class ... classes) {
        this.luceneQuery = luceneQuery;
        this.entityLoader = new CacheEntityLoader(cache);
        this.searchFactory = searchFactory;
        this.targetedEntities = this.searchFactory.getIndexedTypesPolymorphic(classes);
        this.classes = classes;
    }

    @Override
    public void setFilter(Filter f) {
        this.filter = f;
    }

    @Override
    public int getResultSize() {
        if (this.resultSize == null) {
            IndexSearcher searcher = this.buildSearcher(this.searchFactory);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    TopDocs hits = this.getQueryHits((Searcher)searcher, (Integer)Integer.valueOf((int)1)).topDocs;
                    this.resultSize = hits.totalHits;
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to query Lucene index", (Throwable)e);
                }
                finally {
                    try {
                        this.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
                    }
                    catch (SearchException e) {
                        log.warn((Object)("Unable to properly close searcher during lucene query: " + (Object)((Object)e)));
                    }
                }
            }
        }
        return this.resultSize;
    }

    private void closeSearcher(Searcher searcher, ReaderProvider readerProvider) {
        Set indexReaders = ReaderProviderHelper.getIndexReaders((Searchable)searcher);
        for (IndexReader indexReader : indexReaders) {
            readerProvider.closeReader(indexReader);
        }
    }

    @Override
    public void setSort(Sort s) {
        this.sort = s;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        FullTextFilterImpl filterDefinition;
        if (this.filterDefinitions == null) {
            this.filterDefinitions = new HashMap<String, FullTextFilterImpl>();
        }
        if ((filterDefinition = this.filterDefinitions.get(name)) != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.searchFactory.getFilterDefinition(name);
        if (filterDef == null) {
            throw new SearchException("Unkown @FullTextFilter: " + name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.filterDefinitions.remove(name);
    }

    @Override
    public void setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
    }

    @Override
    public QueryResultIterator iterator() throws HibernateException {
        return this.iterator(1);
    }

    @Override
    public QueryResultIterator iterator(int fetchSize) throws HibernateException {
        ArrayList<CacheEntityId> ids = null;
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            throw new NullPointerException("IndexSearcher instance is null.");
        }
        try {
            QueryHits queryHits = this.getQueryHits((Searcher)searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ids = new ArrayList<CacheEntityId>(size);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            for (int index = first; index <= max; ++index) {
                String documentId = (String)((Object)extractor.extract((int)index).id);
                CacheEntityId id = new CacheEntityId(documentId);
                ids.add(id);
            }
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
        return new QueryResultIteratorImpl(ids, this.entityLoader, fetchSize);
    }

    @Override
    public QueryResultIterator lazyIterator() {
        return this.lazyIterator(1);
    }

    @Override
    public QueryResultIterator lazyIterator(int fetchSize) {
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        try {
            QueryHits queryHits = this.getQueryHits((Searcher)searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            return new LazyQueryResultIterator(extractor, this.entityLoader, searcher, this.searchFactory, first, max, fetchSize);
        }
        catch (IOException e) {
            try {
                IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
            }
            catch (SearchException ee) {
                // empty catch block
            }
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
    }

    @Override
    public List<Object> list() throws HibernateException {
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            List list;
            int first;
            int max;
            QueryHits queryHits = this.getQueryHits((Searcher)searcher, this.calculateTopDocsRetrievalSize());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Number of hits are " + queryHits.totalHits));
            }
            int size = (max = this.max(first = this.first(), queryHits.totalHits)) - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<CacheEntityId> ids = new ArrayList<CacheEntityId>(size);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            for (int index = first; index <= max; ++index) {
                String documentId = (String)((Object)extractor.extract((int)index).id);
                CacheEntityId id = new CacheEntityId(documentId);
                ids.add(id);
            }
            List list2 = this.entityLoader.load(ids);
            if (this.resultTransformer == null) {
                list = list2;
                return list;
            }
            list = this.resultTransformer.transformList(list2);
            return list;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    private QueryHits getQueryHits(Searcher searcher, Integer n) throws IOException {
        Query query = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        QueryHits queryHits = n == null ? new QueryHits(searcher, query, this.filter, this.sort) : new QueryHits(searcher, query, this.filter, this.sort, n);
        this.resultSize = queryHits.totalHits;
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        return this.first() + this.maxResults;
    }

    @Override
    public void setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
    }

    private IndexSearcher buildSearcher(SearchFactoryImplementor searchFactoryImplementor) {
        Map builders = searchFactoryImplementor.getDocumentBuildersIndexedEntities();
        ArrayList<DirectoryProvider> directories = new ArrayList<DirectoryProvider>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        if (this.targetedEntities.size() == 0) {
            if (builders.isEmpty()) {
                throw new HibernateException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (DocumentBuilderIndexedEntity builder : builders.values()) {
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = null;
        } else {
            DocumentBuilderIndexedEntity builder;
            HashSet involvedClasses = new HashSet(this.targetedEntities.size());
            involvedClasses.addAll(this.targetedEntities);
            for (Class<Object> clazz : this.targetedEntities) {
                builder = (DocumentBuilderIndexedEntity)builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class<Object> clazz : involvedClasses) {
                builder = (DocumentBuilderIndexedEntity)builders.get(clazz);
                if (builder == null) {
                    throw new HibernateException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (DirectoryProvider dp : directories) {
                Set classesInDirectoryProvider = searchFactoryImplementor.getClassesInDirectoryProvider(dp);
                if (classesInDirectoryProvider.size() > 1) {
                    for (Class clazz : classesInDirectoryProvider) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        }
        DirectoryProvider[] directoryProviders = directories.toArray(new DirectoryProvider[directories.size()]);
        IndexSearcher is = new IndexSearcher(searchFactoryImplementor.getReaderProvider().openReader(directoryProviders));
        is.setSimilarity(searcherSimilarity);
        return is;
    }

    private Similarity checkSimilarity(Similarity similarity, DocumentBuilderIndexedEntity builder) {
        if (similarity == null) {
            similarity = builder.getSimilarity();
        } else if (!similarity.getClass().equals(builder.getSimilarity().getClass())) {
            throw new HibernateException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + builder.getSimilarity().getClass().getName() + ")");
        }
        return similarity;
    }

    private void populateDirectories(List<DirectoryProvider> directories, DirectoryProvider[] directoryProviders) {
        for (DirectoryProvider provider : directoryProviders) {
            if (directories.contains(provider)) continue;
            directories.add(provider);
        }
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private void buildFilters() {
        if (this.filterDefinitions == null || this.filterDefinitions.size() == 0) {
            return;
        }
        ChainedFilter chainedFilter = new ChainedFilter();
        for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
            Filter filter = this.buildLuceneFilter(fullTextFilter);
            chainedFilter.addFilter(filter);
        }
        if (this.filter != null) {
            chainedFilter.addFilter(this.filter);
        }
        this.filter = chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        Filter filter;
        FilterDef def = this.searchFactory.getFilterDefinition(fullTextFilter.getName());
        Object instance = this.createFilterInstance(fullTextFilter, def);
        FilterKey key = this.createFilterKey(def, instance);
        Filter filter2 = filter = FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode()) ? this.searchFactory.getFilterCachingStrategy().getCachedFilter(key) : null;
        if (filter == null) {
            filter = this.createFilter(def, instance);
            if (FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode())) {
                this.searchFactory.getFilterCachingStrategy().addCachedFilter(key, filter);
            }
        }
        return filter;
    }

    private Filter createFilter(FilterDef def, Object instance) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
        }
        try {
            filter = (Filter)instance;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), (Throwable)e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance;
        try {
            instance = def.getImpl().newInstance();
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), (Throwable)e);
        }
        for (Map.Entry entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke((String)entry.getKey(), instance, entry.getValue());
        }
        if (FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode()) && def.getKeyMethod() == null && fullTextFilter.getParameters().size() > 0) {
            throw new SearchException("Filter with parameters and no @Key method: " + fullTextFilter.getName());
        }
        return instance;
    }

    private FilterKey createFilterKey(FilterDef def, Object instance) {
        FilterKey key = null;
        if (!FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode())) {
            return key;
        }
        if (def.getKeyMethod() == null) {
            key = new FilterKey(){

                public int hashCode() {
                    return this.getImpl().hashCode();
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof FilterKey)) {
                        return false;
                    }
                    FilterKey that = (FilterKey)obj;
                    return this.getImpl().equals(that.getImpl());
                }
            };
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
        }
        key.setImpl(def.getImpl());
        StandardFilterKey wrapperKey = new StandardFilterKey();
        wrapperKey.addParameter((Object)def.getName());
        wrapperKey.addParameter((Object)key);
        return wrapperKey;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults((FilterCacheModeType)def.getCacheMode())) {
            int cachingWrapperFilterSize = this.searchFactory.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }
}

