/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.IndexSearcherCloser;
import org.jboss.cache.search.QueryResultIterator;

public class LazyQueryResultIterator
implements QueryResultIterator {
    private int index = 0;
    private int bufferIndex = -1;
    private int max = 0;
    private int first = 0;
    private int fetchSize = 0;
    private CacheEntityLoader entityLoader;
    private DocumentExtractor extractor;
    private IndexSearcher searcher;
    private SearchFactoryImplementor searchFactory;
    Object[] buffer;

    public LazyQueryResultIterator(DocumentExtractor extractor, CacheEntityLoader entityLoader, IndexSearcher searcher, SearchFactoryImplementor searchFactory, int first, int max, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchsize passed. Your fetchSize is less than 1");
        }
        this.extractor = extractor;
        this.entityLoader = entityLoader;
        this.index = first;
        this.first = first;
        this.max = max;
        this.fetchSize = fetchSize;
        this.searcher = searcher;
        this.searchFactory = searchFactory;
        this.buffer = new Object[this.fetchSize];
    }

    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index < this.first || index > this.max) {
            throw new IndexOutOfBoundsException("The given index is incorrect. Please check and try again.");
        }
        this.index = this.first + index;
    }

    public void first() {
        this.index = this.first;
    }

    public void last() {
        this.index = this.max;
    }

    public void afterFirst() {
        this.index = this.first + 1;
    }

    public void beforeLast() {
        this.index = this.max - 1;
    }

    public boolean isFirst() {
        return this.index == this.first;
    }

    public boolean isLast() {
        return this.index == this.max;
    }

    public boolean isAfterFirst() {
        return this.index == this.first + 1;
    }

    public boolean isBeforeLast() {
        return this.index == this.max - 1;
    }

    public void close() {
        IndexSearcherCloser.closeSearcher((Searcher)this.searcher, this.searchFactory.getReaderProvider());
    }

    public boolean hasNext() {
        return this.index <= this.max;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no next");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index >= this.bufferIndex && this.index < this.bufferIndex + bufferSize) {
            int indexToReturn = this.index - this.bufferIndex;
            toReturn = this.buffer[indexToReturn];
        } else {
            try {
                String documentId = (String)((Object)this.extractor.extract((int)this.index).id);
                CacheEntityId id = new CacheEntityId(documentId);
                toReturn = this.entityLoader.load(id);
                Arrays.fill(this.buffer, null);
                this.buffer[0] = toReturn;
                for (int i = 1; i < bufferSize; ++i) {
                    Object toBuffer;
                    String bufferDocumentId = (String)((Object)this.extractor.extract((int)(this.index + i)).id);
                    CacheEntityId bufferId = new CacheEntityId(bufferDocumentId);
                    this.buffer[i] = toBuffer = this.entityLoader.load(bufferId);
                }
                this.bufferIndex = this.index;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ++this.index;
        return toReturn;
    }

    public boolean hasPrevious() {
        return this.index >= this.first;
    }

    public Object previous() {
        if (!this.hasPrevious()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no previous");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index <= this.bufferIndex && this.index >= this.bufferIndex + bufferSize) {
            int indexToReturn = this.bufferIndex - this.index;
            toReturn = this.buffer[indexToReturn];
        }
        try {
            Arrays.fill(this.buffer, null);
            String documentId = (String)((Object)this.extractor.extract((int)this.index).id);
            CacheEntityId id = new CacheEntityId(documentId);
            this.buffer[0] = toReturn = this.entityLoader.load(id);
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                String bufferDocumentId = (String)((Object)this.extractor.extract((int)(this.index - i)).id);
                CacheEntityId bufferId = new CacheEntityId(bufferDocumentId);
                this.buffer[i] = toBuffer = this.entityLoader.load(bufferId);
            }
            this.bufferIndex = this.index;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        --this.index;
        return toReturn;
    }

    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries.");
        }
        return this.index - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }
}

