/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import org.jboss.cache.Fqn;
import org.jboss.cache.search.InvalidFqnException;
import org.jboss.cache.search.InvalidKeyException;

public class Transformer {
    public static String getKey(String docId) {
        int startIndex = docId.indexOf("Key=[");
        int endIndex = docId.indexOf("]", startIndex);
        String key = docId.substring(startIndex += 5, endIndex);
        return key;
    }

    public static Fqn getFqn(String docId) {
        int startIndex = docId.indexOf("[") + 1;
        int endIndex = docId.indexOf("]");
        String fqnString = docId.substring(startIndex, endIndex);
        Fqn fqn = Fqn.fromString((String)fqnString);
        return fqn;
    }

    public static String generateId(Fqn fqn, String key) throws InvalidFqnException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Key passed in cannot be null!");
        }
        if (key.startsWith("Fqn")) {
            throw new InvalidKeyException("Invalid key passed in - 'Fqn[' is not allowed");
        }
        if (key.startsWith("]Key=[")) {
            throw new InvalidKeyException("Invalid key passed in - ']Key=[' is not allowed");
        }
        if (fqn == null) {
            throw new NullPointerException("Fqn cannot be null");
        }
        if (fqn.toString().startsWith("/Fqn")) {
            throw new InvalidFqnException("Invalid Fqn passed in.");
        }
        if (fqn.toString().startsWith("/]Key")) {
            throw new InvalidFqnException("Invalid Fqn passed in.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Fqn=[");
        sb.append(fqn);
        sb.append("]Key=[");
        sb.append(key);
        sb.append("]");
        return sb.toString();
    }
}

