/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.ucl.test;

import java.net.URL;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;
import org.jboss.test.classpool.ucl.support.GlobalUCLInfo;
import org.jboss.test.classpool.ucl.support.ParentLastURLClassLoaderInfo;
import org.jboss.test.classpool.ucl.support.SupportArchives;
import org.jboss.test.classpool.ucl.support.SupportClasses;
import org.jboss.test.classpool.ucl.support.UCLFactory;
import org.jboss.test.classpool.ucl.support.UCLInfo;
import org.jboss.test.classpool.ucl.test.RepositoryTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryClassPoolTestCase
extends RepositoryTest<CtClass, ClassPool> {
    public RepositoryClassPoolTestCase(String name) {
        super(name);
    }

    @Override
    protected TestScenario<CtClass, ClassPool, UCLInfo> getTestScenario() {
        return new ClassPoolTestScenario((ClassLoaderFactory)new UCLFactory());
    }

    @Override
    public void testUclWithParentClassLoaderAndSameClassInDomain() {
    }

    @Override
    public void testUclLoaderOrdering() {
    }

    public void testURLChildOfGlobalUcParentLast() throws Exception {
        ClassPool globalPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        ClassLoader globalClassLoader = this.testScenario.getClassLoader((Object)globalPool);
        ClassPool childPoolA = this.createParentLastURLClassPool(SupportArchives.JAR_B_1_URL, globalClassLoader);
        CtClass aFromA = (CtClass)this.testScenario.loadClass((Object)childPoolA, (Object)globalPool, SupportClasses.CLASS_A);
        CtClass aFromGlobal = (CtClass)this.testScenario.loadClass((Object)globalPool, SupportClasses.CLASS_A);
        RepositoryClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromGlobal);
        CtClass bFromA = childPoolA.get(SupportClasses.CLASS_B);
        RepositoryClassPoolTestCase.assertSame((Object)childPoolA, (Object)bFromA.getClassPool());
        ClassPool childPoolB = this.createParentLastURLClassPool(SupportArchives.JAR_A_2_URL, globalClassLoader);
        CtClass aFromB = childPoolB.get(SupportClasses.CLASS_A);
        RepositoryClassPoolTestCase.assertSame((Object)childPoolB, (Object)aFromB.getClassPool());
    }

    private ClassPool createParentLastURLClassPool(URL url, ClassLoader parent) throws Exception {
        ClassPool pool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new ParentLastURLClassLoaderInfo(url, parent));
        pool.childFirstLookup = true;
        return pool;
    }
}

