/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.ucl.test;

import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.test.classpool.support.ClassFactory;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;
import org.jboss.test.classpool.ucl.support.GlobalUCLInfo;
import org.jboss.test.classpool.ucl.support.SupportArchives;
import org.jboss.test.classpool.ucl.support.SupportClasses;
import org.jboss.test.classpool.ucl.support.UCLFactory;
import org.jboss.test.classpool.ucl.support.UCLInfo;
import org.jboss.test.classpool.ucl.support.URLClassLoaderInfo;
import org.jboss.test.classpool.ucl.test.UclClassPoolTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtClassCreationTestCase
extends UclClassPoolTest<CtClass, ClassPool> {
    public CtClassCreationTestCase(String name) {
        super(name);
    }

    @Override
    protected TestScenario<CtClass, ClassPool, UCLInfo> getTestScenario() {
        return new ClassPoolTestScenario((ClassLoaderFactory)new UCLFactory());
    }

    public void testGeneratingClassInNonDelegatingPool() throws Exception {
        String PARENT = "parent.Parent";
        String CHILD = "child.Child";
        ClassPool parent = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_B_1_URL));
        ClassPool global = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL, this.testScenario.getClassLoader((Object)parent)));
        ClassPool child = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_C_1_URL, this.testScenario.getClassLoader((Object)global)));
        this.testScenario.cannotLoadClass((Object)parent, "parent.Parent");
        this.testScenario.cannotLoadClass((Object)global, "parent.Parent");
        this.testScenario.cannotLoadClass((Object)child, "parent.Parent");
        this.testScenario.cannotLoadClass((Object)child, "child.Child");
        CtClass parentClass = parent.makeClass("parent.Parent");
        CtClass childClass = child.makeClass("child.Child");
        childClass.setSuperclass(parentClass);
        CtClass parentFromParent = parent.getCtClass("parent.Parent");
        CtClassCreationTestCase.assertSame((Object)parentClass, (Object)parentFromParent);
        CtClass childFromChild = child.getCtClass("child.Child");
        CtClassCreationTestCase.assertSame((Object)childClass, (Object)childFromChild);
        this.testScenario.cannotLoadClass((Object)global, "child.Child");
        CtClass parentFromChildA = childClass.getSuperclass();
        CtClassCreationTestCase.assertSame((Object)parentClass, (Object)parentFromChildA);
        CtClass parentFromChildB = child.getCtClass("parent.Parent");
        CtClassCreationTestCase.assertSame((Object)parent, (Object)parentFromChildB.getClassPool());
        CtClassCreationTestCase.assertSame((Object)parentClass, (Object)parentFromChildB);
        Class parentClazz = parentClass.toClass();
        CtClassCreationTestCase.assertSame((Object)parent.getClassLoader(), (Object)parentClazz.getClassLoader());
        Class childClazz = childClass.toClass();
        CtClassCreationTestCase.assertSame((Object)child.getClassLoader(), (Object)childClazz.getClassLoader());
        Class<?> parentClazzFromParent = parent.getClassLoader().loadClass("parent.Parent");
        CtClassCreationTestCase.assertSame((Object)parentClazz, parentClazzFromParent);
        Class<?> parentClazzFromChild = parent.getClassLoader().loadClass("parent.Parent");
        CtClassCreationTestCase.assertSame((Object)parentClazz, parentClazzFromChild);
        Class<?> childClazzFromChild = child.getClassLoader().loadClass("child.Child");
        CtClassCreationTestCase.assertSame((Object)childClazz, childClazzFromChild);
        child.getClassLoader().loadClass(SupportClasses.CLASS_A);
    }

    public void testGeneratingClassInDelegatingPool() throws Exception {
        ClassPool globalA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        ClassPool globalB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_B_1_URL));
        ClassPool child = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_C_1_URL, this.testScenario.getClassLoader((Object)globalA)));
        String A_CLASS = "a.Clazz";
        String B_CLASS = "b.Clazz";
        this.testScenario.cannotLoadClass((Object)globalA, "a.Clazz");
        this.testScenario.cannotLoadClass((Object)globalB, "a.Clazz");
        this.testScenario.cannotLoadClass((Object)child, "a.Clazz");
        this.testScenario.cannotLoadClass((Object)globalA, "b.Clazz");
        this.testScenario.cannotLoadClass((Object)globalB, "b.Clazz");
        this.testScenario.cannotLoadClass((Object)child, "b.Clazz");
        CtClass a = globalA.makeClass("a.Clazz");
        CtClass b = globalB.makeClass("b.Clazz");
        CtClass aFromA = globalA.getCtClass("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)a, (Object)aFromA);
        CtClassCreationTestCase.assertSame((Object)globalA, (Object)aFromA.getClassPool());
        CtClass aFromB = globalB.get("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)a, (Object)aFromB);
        CtClass bFromA = globalA.get("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)b, (Object)bFromA);
        CtClassCreationTestCase.assertSame((Object)globalB, (Object)bFromA.getClassPool());
        CtClass bFromB = globalB.get("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)b, (Object)bFromB);
        CtClass aFromChild = child.get("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)a, (Object)aFromChild);
        CtClass bFromChild = child.get("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)b, (Object)bFromChild);
        Class clazzA = a.toClass();
        CtClassCreationTestCase.assertSame((Object)globalA.getClassLoader(), (Object)clazzA.getClassLoader());
        Class clazzB = b.toClass();
        CtClassCreationTestCase.assertSame((Object)globalB.getClassLoader(), (Object)clazzB.getClassLoader());
        Class<?> clazzAFromA = globalA.getClassLoader().loadClass("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzA, clazzAFromA);
        Class<?> clazzAFromB = globalB.getClassLoader().loadClass("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzA, clazzAFromB);
        Class<?> clazzAFromChild = child.getClassLoader().loadClass("a.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzA, clazzAFromChild);
        Class<?> clazzBFromA = globalA.getClassLoader().loadClass("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzB, clazzBFromA);
        Class<?> clazzBFromB = globalB.getClassLoader().loadClass("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzB, clazzBFromB);
        Class<?> clazzBFromChild = child.getClassLoader().loadClass("b.Clazz");
        CtClassCreationTestCase.assertSame((Object)clazzB, clazzBFromChild);
    }

    public void testCreateClassInSamePackage() throws Exception {
        ClassPool globalPoolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        ClassPool globalPoolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_B_1_URL));
        ClassLoader loaderA = globalPoolA.getClassLoader();
        ClassLoader loaderB = globalPoolB.getClassLoader();
        Class<?> classA = loaderA.loadClass(SupportClasses.CLASS_A);
        Class<?> classB = loaderB.loadClass(SupportClasses.CLASS_B);
        ClassPoolRepository repository = ClassPoolRepository.getInstance();
        Object createdA = ClassFactory.create(classA, (ClassLoader)loaderA, (ClassPoolRepository)repository);
        Object createdB = ClassFactory.create(classB, (ClassLoader)loaderB, (ClassPoolRepository)repository);
        Class<?> createdClassA = createdA.getClass();
        Class<?> createdClassB = createdB.getClass();
        CtClassCreationTestCase.assertTrue((boolean)classA.isAssignableFrom(createdClassA));
        CtClassCreationTestCase.assertTrue((boolean)classB.isAssignableFrom(createdClassB));
        CtClassCreationTestCase.assertTrue((boolean)createdClassA.getName().startsWith(SupportClasses.PACKAGE_A));
        CtClassCreationTestCase.assertTrue((boolean)createdClassB.getName().startsWith(SupportClasses.PACKAGE_B));
        CtClassCreationTestCase.assertSame(createdClassA, loaderA.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderA.loadClass(createdClassB.getName()));
        CtClassCreationTestCase.assertSame(createdClassA, loaderB.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderB.loadClass(createdClassB.getName()));
    }

    public void testCreatedClassForSystemClass() throws Exception {
        ClassPool globalPoolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        ClassPool globalPoolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_B_1_URL));
        ClassLoader loaderA = globalPoolA.getClassLoader();
        ClassLoader loaderB = globalPoolB.getClassLoader();
        ClassPoolRepository repository = ClassPoolRepository.getInstance();
        Object createdA = ClassFactory.create(ArrayList.class, (ClassLoader)loaderA, (ClassPoolRepository)repository);
        Object createdB = ClassFactory.create(ArrayList.class, (ClassLoader)loaderB, (ClassPoolRepository)repository);
        Class<?> createdClassA = createdA.getClass();
        Class<?> createdClassB = createdB.getClass();
        CtClassCreationTestCase.assertTrue((boolean)ArrayList.class.isAssignableFrom(createdClassA));
        CtClassCreationTestCase.assertTrue((boolean)ArrayList.class.isAssignableFrom(createdClassB));
        CtClassCreationTestCase.assertTrue((boolean)createdClassA.getName().startsWith("org.test.classpool.proxy"));
        CtClassCreationTestCase.assertTrue((boolean)createdClassB.getName().startsWith("org.test.classpool.proxy"));
        CtClassCreationTestCase.assertSame(createdClassA, loaderA.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderA.loadClass(createdClassB.getName()));
        CtClassCreationTestCase.assertSame(createdClassA, loaderB.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderB.loadClass(createdClassB.getName()));
    }
}

