/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.ucl.support;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.ucl.support.SupportClasses;
import org.jboss.test.classpool.ucl.support.UCLInfo;
import org.jboss.util.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCLFactory
implements ClassLoaderFactory<UCLInfo> {
    static final ObjectName MAIN_LOADER_REPOSITORY_OBJECT_NAME;
    private LoaderRepository globalRepository;
    static final Set<ClassLoader> registeredClassLoaders;

    public UCLFactory() {
        try {
            MBeanServer mBeanServer = MBeanServerLocator.locateJBoss();
            this.globalRepository = (LoaderRepository)mBeanServer.invoke(MAIN_LOADER_REPOSITORY_OBJECT_NAME, "getInstance", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public ClassLoader create(UCLInfo uclInfo) throws Exception {
        ClassLoader classLoader = uclInfo.create(this.globalRepository);
        registeredClassLoaders.add(classLoader);
        return classLoader;
    }

    public void destroy(UCLInfo uclInfo) throws Exception {
        ClassLoader classLoader = uclInfo.getCreatedClassLoader();
        this.destroyClassLoader(classLoader);
        registeredClassLoaders.remove(classLoader);
    }

    public void destroyAll() {
        HashSet<UnifiedLoaderRepository3> repositories = new HashSet<UnifiedLoaderRepository3>();
        for (ClassLoader registeredClassLoader : registeredClassLoaders) {
            LoaderRepository repository = this.destroyClassLoader(registeredClassLoader);
            if (repository == null || !(repository instanceof UnifiedLoaderRepository3)) continue;
            repositories.add((UnifiedLoaderRepository3)repository);
        }
        for (UnifiedLoaderRepository3 repository : repositories) {
            repository.flush();
        }
        registeredClassLoaders.clear();
        for (String className : SupportClasses.getAllSupportClasses()) {
            try {
                this.globalRepository.loadClass(className);
                Assert.fail((String)("Should not have been able to load " + className));
            }
            catch (Exception expected) {
                // empty catch block
            }
        }
    }

    public ClassLoader retrieve(UCLInfo uclInfo) throws Exception {
        return uclInfo.getCreatedClassLoader();
    }

    public Collection<ClassLoader> retrieveAll() {
        return registeredClassLoaders;
    }

    public boolean isAvailable(UCLInfo uclInfo) throws Exception {
        throw new NotImplementedException("Functionality unavailable");
    }

    private LoaderRepository destroyClassLoader(ClassLoader classLoader) {
        if (classLoader != null && classLoader instanceof RepositoryClassLoader) {
            RepositoryClassLoader repoClassLoader = (RepositoryClassLoader)classLoader;
            LoaderRepository repository = repoClassLoader.getLoaderRepository();
            repository.removeClassLoader((ClassLoader)repoClassLoader);
            this.deleteTempDir();
            ClassPoolRepository.getInstance().unregisterClassLoader(classLoader);
            return repository;
        }
        return null;
    }

    private void deleteTempDir() {
        String[] uclFiles;
        File dir = new File(".");
        for (String uclFile : uclFiles = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("ucl");
            }
        })) {
            this.deleteRecursively(dir, uclFile);
        }
    }

    private void deleteRecursively(File dir, String name) {
        File file = new File(dir, name);
        if (file.isDirectory()) {
            String[] fileNames;
            for (String fileName : fileNames = file.list()) {
                this.deleteRecursively(file, fileName);
            }
        }
        file.delete();
    }

    static {
        try {
            MAIN_LOADER_REPOSITORY_OBJECT_NAME = new ObjectName("JMImplementation:name=Default,service=LoaderRepository");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        registeredClassLoaders = new HashSet<ClassLoader>();
    }
}

