/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.ucl.test;

import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.ucl.support.ChildUCLInfo;
import org.jboss.test.classpool.ucl.support.GlobalUCLInfo;
import org.jboss.test.classpool.ucl.support.SupportArchives;
import org.jboss.test.classpool.ucl.support.SupportClasses;
import org.jboss.test.classpool.ucl.support.URLClassLoaderInfo;
import org.jboss.test.classpool.ucl.test.UclClassPoolTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryTest<C, L>
extends UclClassPoolTest<C, L> {
    public RepositoryTest(String name) {
        super(name);
    }

    public void testGlobalScope() throws Exception {
        GlobalUCLInfo uclInfoA = new GlobalUCLInfo(SupportArchives.JAR_A_1_URL);
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)uclInfoA);
        GlobalUCLInfo uclInfoB = new GlobalUCLInfo(SupportArchives.JAR_B_1_URL);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)uclInfoB);
        this.accessGlobalScope(loaderA, loaderB);
        this.accessGlobalScope(loaderA, loaderB);
        this.testScenario.destroyLoader((ClassLoaderInfo)uclInfoB);
        this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
    }

    public void testChildDomain() throws Exception {
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_B_1_URL));
        Object loaderC = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_C_1_URL, false));
        this.accessChildDomain(loaderA, loaderB, loaderC);
        this.accessChildDomain(loaderA, loaderB, loaderC);
    }

    public void testSiblingDomains() throws Exception {
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_A_1_URL, true));
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_B_1_URL, false));
        this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_A);
    }

    public void testChildWithNewClassesInParent() throws Exception {
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_B_1_URL, true));
        this.testScenario.cannotLoadClass(scopedLoader, SupportClasses.CLASS_A);
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object aFromChild = this.testScenario.loadClass(scopedLoader, globalLoader, SupportClasses.CLASS_A);
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromChild, (Object)aFromParent);
        Object aFromChild2 = this.testScenario.loadClass(scopedLoader, globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromChild, (Object)aFromChild2);
    }

    public void testChildOverrideWithParentDelegation() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_A_2_URL, true));
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object aFromChild = this.testScenario.loadClass(scopedLoader, globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromParent, (Object)aFromChild);
    }

    public void testChildOverrideWithNoParentDelegation() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object scopedLoader = this.testScenario.createLoader((ClassLoaderInfo)new ChildUCLInfo(SupportArchives.JAR_A_2_URL, false));
        Object aFromParent = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object aFromChild = this.testScenario.loadClass(scopedLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertNotSame((Object)aFromParent, (Object)aFromChild);
    }

    public void testURLChildOfGlobalUclParentFirst() throws Exception {
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        ClassLoader globalClassLoader = this.testScenario.getClassLoader(globalLoader);
        Object childLoaderA = this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_B_1_URL, globalClassLoader));
        Object aFromA = this.testScenario.loadClass(childLoaderA, globalLoader, SupportClasses.CLASS_A);
        Object aFromGlobal = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromGlobal);
        this.testScenario.loadClass(childLoaderA, SupportClasses.CLASS_B);
        Object childLoaderB = this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_A_2_URL, globalClassLoader));
        Object aFromB = this.testScenario.loadClass(childLoaderB, globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromB);
    }

    public void testUndeploySibling() throws Exception {
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        GlobalUCLInfo uclInfoB = new GlobalUCLInfo(SupportArchives.JAR_B_1_URL);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)uclInfoB);
        this.testScenario.loadClass(loaderA, loaderB, SupportClasses.CLASS_B);
        this.testScenario.destroyLoader((ClassLoaderInfo)uclInfoB);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
    }

    public void testUclWithParentClassLoader() throws Exception {
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_B_1_URL));
        Object globalLoader = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL, this.testScenario.getClassLoader(parentLoader)));
        Object aFromGlobal = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        Object aFromGlobal2 = this.testScenario.loadClass(globalLoader, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromGlobal, (Object)aFromGlobal2);
        Object bFromGlobal = this.testScenario.loadClass(globalLoader, parentLoader, SupportClasses.CLASS_B);
        Object bFromGlobal2 = this.testScenario.loadClass(globalLoader, parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobal, (Object)bFromGlobal2);
        Object bFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        Object bFromParent2 = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromParent, (Object)bFromParent2);
        RepositoryTest.assertSame((Object)bFromGlobal, (Object)bFromParent);
    }

    public void testUclWithParentClassLoaderAndSameClassInDomain() throws Exception {
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)new URLClassLoaderInfo(SupportArchives.JAR_B_1_URL));
        Object globalLoaderA = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL, this.testScenario.getClassLoader(parentLoader)));
        Object aFromGlobal = this.testScenario.loadClass(globalLoaderA, SupportClasses.CLASS_A);
        Object aFromGlobal2 = this.testScenario.loadClass(globalLoaderA, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromGlobal, (Object)aFromGlobal2);
        Object globalLoaderB = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_B_2_URL));
        Object bFromGlobal = this.testScenario.loadClass(globalLoaderA, globalLoaderB, SupportClasses.CLASS_B);
        Object bFromGlobal2 = this.testScenario.loadClass(globalLoaderA, globalLoaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromGlobal, (Object)bFromGlobal2);
        Object bFromParent = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        Object bFromParent2 = this.testScenario.loadClass(parentLoader, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)bFromParent, (Object)bFromParent2);
        RepositoryTest.assertNotSame((Object)bFromGlobal, (Object)bFromParent);
    }

    public void testUclLoaderOrdering() throws Exception {
        Object globalLoaderA = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object globalLoaderB = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object globalLoaderC = this.testScenario.createLoader((ClassLoaderInfo)new GlobalUCLInfo(SupportArchives.JAR_A_1_URL));
        Object aFromA = this.testScenario.loadClass(globalLoaderA, SupportClasses.CLASS_A);
        Object aFromB = this.testScenario.loadClass(globalLoaderB, globalLoaderA, SupportClasses.CLASS_A);
        Object aFromC = this.testScenario.loadClass(globalLoaderC, globalLoaderA, SupportClasses.CLASS_A);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromB);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromC);
    }

    private void accessGlobalScope(L loaderA, L loaderB) throws Exception {
        Object aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        Object bFromA = this.testScenario.loadClass(loaderA, loaderB, SupportClasses.CLASS_B);
        Object aFromB = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        Object bFromB = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromB);
        RepositoryTest.assertSame((Object)bFromA, (Object)bFromB);
    }

    private void accessChildDomain(L loaderA, L loaderB, L loaderC) throws Exception {
        Object aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        Object bFromB = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        Object aFromC = this.testScenario.loadClass(loaderC, loaderA, SupportClasses.CLASS_A);
        Object bFromC = this.testScenario.loadClass(loaderC, loaderB, SupportClasses.CLASS_B);
        RepositoryTest.assertSame((Object)aFromA, (Object)aFromC);
        RepositoryTest.assertSame((Object)bFromB, (Object)bFromC);
        this.testScenario.loadClass(loaderC, SupportClasses.CLASS_C);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_C);
    }
}

