/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.ucl.test;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.classpool.plugins.ucl.UclDelegatingClassPoolFactory;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.classpool.support.TestScenario;
import org.jboss.test.classpool.ucl.support.SupportClasses;
import org.jboss.test.classpool.ucl.support.UCLInfo;
import org.jboss.test.classpool.ucl.test.UclClassPoolTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UclClassPoolTest<C, L>
extends AbstractTestCaseWithSetup {
    protected TestScenario<C, L, UCLInfo> testScenario;

    protected abstract TestScenario<C, L, UCLInfo> getTestScenario();

    protected void setUp() throws Exception {
        super.setUp();
        this.testScenario = this.getTestScenario();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.testScenario.destroyLoaders();
        }
        finally {
            super.tearDown();
        }
    }

    public UclClassPoolTest(String name) {
        super(name);
        System.setProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MBeanServerLocator.setJBoss((MBeanServer)server);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        boolean enableSecurity;
        UclClassPoolTestDelegate delegate = new UclClassPoolTestDelegate(clazz);
        String property = "false";
        delegate.enableSecurity = enableSecurity = Boolean.valueOf(property).booleanValue();
        return delegate;
    }

    public void testClassesNotOnClasspath() {
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), SupportClasses.CLASS_A);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), SupportClasses.CLASS_B);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), SupportClasses.CLASS_C);
    }

    private void assertCannotLoadClass(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            UclClassPoolTest.fail((String)("Should not have been able to load " + className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            ClassPoolRepository.getInstance().setClassPoolFactory((ScopedClassPoolFactory)new UclDelegatingClassPoolFactory(new File(".")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

