/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.classpool.spi;

import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;

/**
 * A factory that creates ClassPool instances based on a corresponding ClassLoader.
 * 
 * @author <a href="mailto:flavia.rainone@jboss.com">Flavia Rainone</a>
 *
 * @version $Revision: 97733 $
 */
public class AbstractClassPoolFactory implements ScopedClassPoolFactory
{
   protected static ClassPool defaultClassPool = ClassPool.getDefault();
   
   /**
    * Determines the ClassPool that will be used to map null class loaders
    * 
    * @param defaultCP maps null class loaders
    */
   public static void setDefaultClassPool(ClassPool defaultCP)
   {
      defaultClassPool = defaultCP;
   }
   
   public AbstractClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
   {
      return new AbstractClassPool(cl, src, repository);
   }

   public AbstractClassPool create(ClassPool src, ScopedClassPoolRepository repository)
   {
      return new AbstractClassPool(src, repository);
   }

}