/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.classpool.base.BaseClassPoolDomain;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolTest
extends AbstractTestCaseWithSetup {
    private static final List<ClassLoader> loaders = new ArrayList<ClassLoader>();

    public ClassPoolTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new ClassPoolTestDelegate(clazz);
    }

    protected static AbstractClassPoolDomain createClassPoolDomain(String name, ClassPoolDomain parent, boolean parentFirst) {
        BaseClassPoolDomain domain = new BaseClassPoolDomain(name, parent, parentFirst);
        return domain;
    }

    protected static DelegatingClassPool createDelegatingClassPool(ClassPoolDomain domain, URL ... urls) throws ClassNotFoundException {
        URLClassLoader loader = new URLClassLoader(urls);
        for (URL url : urls) {
            if (url == SupportArchives.JAR_A_URL) {
                loader.loadClass(SupportClasses.CLASS_A);
                continue;
            }
            if (url != SupportArchives.JAR_B_URL) continue;
            loader.loadClass(SupportClasses.CLASS_B);
        }
        loader = new URLClassLoader(urls);
        loaders.add(loader);
        return new DelegatingClassPool(domain, (ClassLoader)loader, ClassPool.getDefault(), (ScopedClassPoolRepository)ClassPoolRepository.getInstance());
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void assertCannotLoadClass(ClassLoader loader, String classname) {
        try {
            loader.loadClass(classname);
            ClassPoolTest.fail((String)("Should not have been able to load " + classname));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testClassesNotOnClasspath() {
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), SupportClasses.CLASS_A);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), SupportClasses.CLASS_B);
    }
}

