/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTest;

public class SimpleDelegatingClassPoolTestCase
extends ClassPoolTest {
    public SimpleDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    public void testAllClassesOnePool() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool pool = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL, SupportArchives.JAR_B_URL);
        this.accessAllClassesOnePool((ClassPool)pool);
        this.accessAllClassesOnePool((ClassPool)pool);
    }

    private void accessAllClassesOnePool(ClassPool pool) throws Exception {
        CtClass a = pool.get(SupportClasses.CLASS_A);
        CtClass b = pool.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)pool, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)pool, (Object)b.getClassPool());
        CtClass string = pool.get(String.class.getName());
        SimpleDelegatingClassPoolTestCase.assertNotSame((String)"java.lang.String should be loaded by the parent pool", (Object)pool, (Object)string.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)ClassPool.getDefault(), (Object)string.getClassPool());
    }

    public void testOnePoolPerClassLoadedByA() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessOnePoolPerClassLoadedByA((ClassPool)poolA, (ClassPool)poolB);
        this.accessOnePoolPerClassLoadedByA((ClassPool)poolA, (ClassPool)poolB);
    }

    private void accessOnePoolPerClassLoadedByA(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        CtClass b = poolA.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)a.getClassPool(), (Object)b.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)b.getClassPool());
    }

    public void testOnePoolPerClassLoadedByB() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessOnePoolPerClassLoadedByB((ClassPool)poolA, (ClassPool)poolB);
        this.accessOnePoolPerClassLoadedByB((ClassPool)poolA, (ClassPool)poolB);
    }

    public void accessOnePoolPerClassLoadedByB(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass a = poolB.get(SupportClasses.CLASS_A);
        CtClass b = poolB.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)a.getClassPool(), (Object)b.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)b.getClassPool());
    }

    public void testCanLoadArrrayCtClass() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessCanLoadCtArray((ClassPool)poolA, (ClassPool)poolB);
        this.accessCanLoadCtArray((ClassPool)poolA, (ClassPool)poolB);
    }

    private void accessCanLoadCtArray(ClassPool poolA, ClassPool poolB) throws Exception {
        poolA.get(String.class.getName() + "[][]");
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        CtClass aArray = poolA.get(SupportClasses.CLASS_A + "[]");
        CtClass bArray = poolA.get(SupportClasses.CLASS_B + "[][]");
        CtClass b = poolA.get(SupportClasses.CLASS_B);
        CtClass byteClassA = poolA.get("byte");
        CtClass byteClassB = poolB.get("byte");
        SimpleDelegatingClassPoolTestCase.assertSame((Object)byteClassA, (Object)byteClassB);
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)poolA, (Object)byteClassA.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)poolB, (Object)byteClassA.getClassPool());
        CtClass intArrayClass = poolA.get("int[]");
        CtClass intClass = poolB.get("int");
        SimpleDelegatingClassPoolTestCase.assertSame((Object)intClass, (Object)intArrayClass.getComponentType());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)byteClassA.getClassPool(), (Object)intClass.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)aArray.isArray());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)a, (Object)aArray.getComponentType());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)bArray.isArray());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)bArray.getComponentType().isArray());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)b, (Object)bArray.getComponentType().getComponentType());
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)aArray.getClassPool(), (Object)bArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)poolA, (Object)aArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)poolB, (Object)bArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)a.getClassPool(), (Object)aArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)b.getClassPool(), (Object)bArray.getClassPool());
    }
}

