/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.classpool.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolRepository
implements ScopedClassPoolRepository {
    private static final ClassPoolRepository instance = new ClassPoolRepository();
    protected ScopedClassPoolRepository delegate;
    private ClassPoolRepositoryCallback callback;
    private Collection<ClassLoader> currentClassLoaders = new HashSet<ClassLoader>();

    public static ClassPoolRepository getInstance() {
        return instance;
    }

    protected ClassPoolRepository() {
        this.delegate = ScopedClassPoolRepositoryImpl.getInstance();
    }

    public void setClassPoolFactory(ScopedClassPoolFactory factory) {
        this.delegate.setClassPoolFactory(factory);
    }

    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.delegate.getClassPoolFactory();
    }

    public synchronized void setClassPoolRepositoryCallback(ClassPoolRepositoryCallback callback) {
        this.callback = callback;
    }

    public synchronized ClassPoolRepositoryCallback getClassPoolRepositoryCallback() {
        return this.callback;
    }

    public boolean isPrune() {
        return this.delegate.isPrune();
    }

    public void setPrune(boolean prune) {
        this.delegate.setPrune(prune);
    }

    public ScopedClassPool createScopedClassPool(ClassLoader classLoader, ClassPool parent) {
        return this.delegate.createScopedClassPool(classLoader, parent);
    }

    public ClassPool findClassPool(ClassLoader classLoader) {
        return this.delegate.findClassPool(classLoader);
    }

    public Map<ClassLoader, ClassPool> getRegisteredCLs() {
        return this.delegate.getRegisteredCLs();
    }

    public void clearUnregisteredClassLoaders() {
        this.delegate.clearUnregisteredClassLoaders();
    }

    public synchronized ClassPool registerClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = SecurityActions.getContextClassLoader();
        }
        if (this.currentClassLoaders.contains(classLoader)) {
            return null;
        }
        this.currentClassLoaders.add(classLoader);
        ScopedClassPool classPool = (ScopedClassPool)this.delegate.registerClassLoader(classLoader);
        this.currentClassLoaders.remove(classLoader);
        if (classPool != null && this.callback != null) {
            this.callback.classLoaderRegistered(classLoader);
        }
        return classPool;
    }

    public synchronized void unregisterClassLoader(ClassLoader classLoader) {
        this.delegate.unregisterClassLoader(classLoader);
        if (this.callback != null) {
            this.callback.classLoaderUnregistered(classLoader);
        }
    }
}

