/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.support;

import junit.framework.Assert;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.TestScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanityTestScenario<I extends ClassLoaderInfo>
extends TestScenario<Class<?>, ClassLoader, I> {
    public SanityTestScenario(ClassLoaderFactory<I> classLoaderFactory) {
        super(classLoaderFactory);
    }

    @Override
    public ClassLoader getLoader(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    @Override
    public ClassLoader getLoader(ClassLoader classLoader) {
        return classLoader;
    }

    @Override
    public ClassLoader getClassLoader(ClassLoader loader) {
        return loader;
    }

    @Override
    public Class<?> loadClass(ClassLoader loader, ClassLoader expected, String className) throws Exception {
        return this.assertLoadClass(loader, expected, className);
    }

    @Override
    public void cannotLoadClass(ClassLoader classLoader, String className) {
        try {
            classLoader.loadClass(className);
            Assert.fail((String)("Should not have been able to load " + className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public Class<?> getMethodReturnType(Class<?> clazz, String methodName) throws Exception {
        return clazz.getDeclaredMethod(methodName, new Class[0]).getReturnType();
    }
}

