/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.support;

import java.util.Collection;
import junit.framework.Assert;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestScenario<C, L, I extends ClassLoaderInfo> {
    private ClassLoaderFactory<I> classLoaderFactory;

    public TestScenario(ClassLoaderFactory<I> classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    public void createDomain(String name) throws Exception {
        this.classLoaderFactory.createDomain(name);
    }

    public L createLoader(I classLoaderInfo) throws Exception {
        ClassLoader classLoader = this.classLoaderFactory.create(classLoaderInfo);
        return this.getLoader(classLoader);
    }

    public void destroyLoader(I classLoaderInfo) throws Exception {
        this.classLoaderFactory.destroy(classLoaderInfo);
    }

    public void destroyLoaders() {
        this.preDestroy(this.classLoaderFactory.retrieveAll());
        this.classLoaderFactory.destroyAll();
    }

    public L getLoader(I classLoaderInfo) throws Exception {
        ClassLoader classLoader = this.classLoaderFactory.retrieve(classLoaderInfo);
        return this.getLoader(classLoader);
    }

    public void cannotGetLoader(I classLoaderInfo) throws Exception {
        Assert.assertFalse((String)"Class loader should not be available", (boolean)this.classLoaderFactory.isAvailable(classLoaderInfo));
    }

    public abstract L getLoader(C var1);

    public abstract L getLoader(ClassLoader var1);

    public abstract ClassLoader getClassLoader(L var1);

    public C loadClass(L loader, String className) throws Exception {
        return this.loadClass(loader, loader, className);
    }

    public abstract C loadClass(L var1, L var2, String var3) throws Exception;

    public abstract void cannotLoadClass(L var1, String var2);

    public abstract C getMethodReturnType(C var1, String var2) throws Exception;

    protected Class<?> assertLoadClass(ClassLoader initiating, ClassLoader expected, String className) throws Exception {
        Class<?> clazz = initiating.loadClass(className);
        if (expected != null) {
            Assert.assertSame((Object)expected, (Object)clazz.getClassLoader());
        }
        return clazz;
    }

    protected void preDestroy(Collection<ClassLoader> classLoaders) {
    }
}

