/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.test.classpool.support.ClassFactory;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTest;

public class ParentLastDelegatingClassPoolTestCase
extends ClassPoolTest {
    public ParentLastDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    public void testChildInParent() throws Exception {
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildInParent((ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInParent((ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInParent(ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)childPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a2.getClassPool());
    }

    public void testChildInGrandParent() throws Exception {
        AbstractClassPoolDomain grandParent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, false);
        DelegatingClassPool grandParentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildInGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInGrandParent((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInGrandParent(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)childPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        CtClass a3 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
    }

    public void testChildInGrandParentFromTop() throws Exception {
        AbstractClassPoolDomain grandParent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, false);
        DelegatingClassPool grandParentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        this.accessChildInGrandParentFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInGrandParentFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInGrandParentFromTop(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        CtClass a3 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)childPool, (Object)a3.getClassPool());
    }

    public void testChildInSibling() throws Exception {
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain childA = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILDA", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPoolA = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)childA, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain childB = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILDB", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPoolB = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)childB, SupportArchives.JAR_A_URL);
        this.accessChildInSibling((ClassPool)parentPool, (ClassPool)childPoolA, (ClassPool)childPoolB);
        this.accessChildInSibling((ClassPool)parentPool, (ClassPool)childPoolA, (ClassPool)childPoolB);
    }

    private void accessChildInSibling(ClassPool parentPool, ClassPool childPoolA, ClassPool childPoolB) throws Exception {
        CtClass a1 = childPoolA.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)childPoolA, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a2.getClassPool());
        CtClass a3 = childPoolB.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)childPoolB, (Object)a3.getClassPool());
    }

    public void testClassInParentOnly() throws Exception {
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessClassInParentOnly((ClassPool)parentPool, (ClassPool)childPool);
        this.accessClassInParentOnly((ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessClassInParentOnly(ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)parentPool, (Object)a2.getClassPool());
    }

    public void testClassInGrandParentOnly() throws Exception {
        AbstractClassPoolDomain grandParent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, false);
        DelegatingClassPool grandParentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessChildInGrandParentOnly((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInGrandParentOnly((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInGrandParentOnly(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        CtClass a3 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
    }

    public void testClassInGrandParentOnlyFromTop() throws Exception {
        AbstractClassPoolDomain grandParent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("GRANDPARENT", null, false);
        DelegatingClassPool grandParentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)grandParent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", (ClassPoolDomain)grandParent, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        this.accessChildInGrandParentOnlyFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
        this.accessChildInGrandParentOnlyFromTop((ClassPool)grandParentPool, (ClassPool)parentPool, (ClassPool)childPool);
    }

    private void accessChildInGrandParentOnlyFromTop(ClassPool grandParentPool, ClassPool parentPool, ClassPool childPool) throws Exception {
        CtClass a1 = grandParentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a1.getClassPool());
        CtClass a2 = parentPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a2.getClassPool());
        CtClass a3 = childPool.get(SupportClasses.CLASS_A);
        ParentLastDelegatingClassPoolTestCase.assertEquals((Object)grandParentPool, (Object)a3.getClassPool());
    }

    public void testGenerateSameClassInChildAndParent() throws Exception {
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        CtClass parentClazz = ClassFactory.create((ClassPool)parentPool, "test.Test");
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentClazz, (Object)parentPool.get("test.Test"));
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentPool, (Object)parentClazz.getClassPool());
        Class parentClass = parentClazz.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentPool.getClassLoader(), (Object)parentClass.getClassLoader());
        CtClass childClazz = ClassFactory.create((ClassPool)childPool, "test.Test");
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childClazz, (Object)childPool.get("test.Test"));
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childPool, (Object)childClazz.getClassPool());
        Class childClass = childClazz.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childPool.getClassLoader(), (Object)childClass.getClassLoader());
    }

    public void testGenerateSameNestedClassInChildAndParent() throws Exception {
        AbstractClassPoolDomain parent = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("PARENT", null, false);
        DelegatingClassPool parentPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        AbstractClassPoolDomain child = ParentLastDelegatingClassPoolTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, false);
        DelegatingClassPool childPool = ParentLastDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_A_URL);
        CtClass parentA = parentPool.get(SupportClasses.CLASS_A);
        CtClass parentClazz = ClassFactory.createNested(parentA, "Test", true);
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentPool, (Object)parentClazz.getClassPool());
        Class parentClass = parentClazz.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentPool.getClassLoader(), (Object)parentClass.getClassLoader());
        Class parentAClass = parentA.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)parentPool.getClassLoader(), (Object)parentAClass.getClassLoader());
        CtClass childA = childPool.get(SupportClasses.CLASS_A);
        CtClass childClazz = ClassFactory.createNested(childA, "Test", true);
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childPool, (Object)childClazz.getClassPool());
        Class childClass = childClazz.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childPool.getClassLoader(), (Object)childClass.getClassLoader());
        Class childAClass = childA.toClass();
        ParentLastDelegatingClassPoolTestCase.assertSame((Object)childPool.getClassLoader(), (Object)childAClass.getClassLoader());
    }
}

