/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cliresolver;

import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.cliresolver.DmrOperationFailedException;
import org.jboss.cliresolver.ManagementService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CliResolver
extends ELResolver {
    public static final String ROOT = "_root_";
    public static final String IS_DOMAIN = "_isDomain_";
    public static final String CLI = "_CLI_";
    public static final String AS_PROP_LIST = "_asPropertyList_";
    private static final boolean isDomain;
    private static final ModelControllerClient localDmrClient;
    private static ModelControllerClient domainDmrClient;
    private static final CommandContext cliContext;

    public Class<?> getCommonPropertyType(ELContext elCtx, Object base) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elCtx, Object base) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class<?> getType(ELContext elCtx, Object base, Object property) {
        String strProperty = property.toString();
        if ((strProperty = this.replaceCharsNotAllowedInEL(strProperty.trim())).equals(IS_DOMAIN)) {
            elCtx.setPropertyResolved(true);
            return Boolean.class;
        }
        if (strProperty.equals(CLI)) {
            elCtx.setPropertyResolved(true);
            return String.class;
        }
        if (strProperty.equals(AS_PROP_LIST)) {
            elCtx.setPropertyResolved(true);
            return List.class;
        }
        if (this.isPropertyList(strProperty)) {
            elCtx.setPropertyResolved(true);
            return ModelNode.class;
        }
        if (base == null) {
            return null;
        }
        if (base.equals(CLI)) {
            elCtx.setPropertyResolved(true);
            return ModelNode.class;
        }
        if (!(base instanceof ModelNode)) {
            return null;
        }
        elCtx.setPropertyResolved(true);
        ModelNode operation = ((ModelNode)base).clone();
        operation.get("operation").set("read-resource-description");
        try {
            ModelNode result = this.dmrClient().execute(operation);
            ModelType type = result.get(new String[]{"result", "attributes", strProperty, "type"}).asType();
            return this.convertToJavaType(type);
        }
        catch (IOException e) {
            throw new ELException((Throwable)e);
        }
    }

    public Object getValue(ELContext elCtx, Object base, Object property) {
        ModelNode node;
        if (property.equals(IS_DOMAIN)) {
            elCtx.setPropertyResolved(true);
            return isDomain;
        }
        if (property.equals(CLI)) {
            elCtx.setPropertyResolved(true);
            return CLI;
        }
        if (property.equals(AS_PROP_LIST)) {
            elCtx.setPropertyResolved(true);
            ModelNode node2 = (ModelNode)base;
            return node2.asPropertyList();
        }
        boolean isPropertyList = this.isPropertyList(base);
        if (!(base == null || base instanceof ModelNode || isPropertyList || base.equals(CLI))) {
            return null;
        }
        if (!isPropertyList && base instanceof ModelNode && (node = (ModelNode)base).getType() == ModelType.LIST) {
            return null;
        }
        String strProperty = (String)property;
        strProperty = this.replaceCharsNotAllowedInEL(strProperty.trim());
        boolean propIsAddress = this.isAddress(strProperty);
        if (base == null && !propIsAddress) {
            return null;
        }
        elCtx.setPropertyResolved(true);
        if (base == null) {
            ModelNode operation = new ModelNode();
            if (strProperty.equals(ROOT)) {
                operation.get("address").setEmptyList();
                return operation;
            }
            return this.addAddress(operation, strProperty);
        }
        if (isPropertyList) {
            List propList = ((ModelNode)base).asPropertyList();
            for (Property prop : propList) {
                if (!prop.getName().equals(property)) continue;
                return this.convertValueToJavaType(prop.getValue());
            }
            return null;
        }
        if (base.equals(CLI)) {
            return this.executeCLI(strProperty);
        }
        ModelNode modelNode = (ModelNode)base;
        if (propIsAddress) {
            return this.addAddress(modelNode, strProperty);
        }
        if (modelNode.hasDefined(strProperty)) {
            ModelNode value = modelNode.get(strProperty);
            if (this.isPropertyList(value)) {
                return value;
            }
            return this.convertValueToJavaType(value);
        }
        modelNode = modelNode.clone();
        modelNode.get("operation").set("read-attribute");
        modelNode.get("name").set(strProperty);
        Object finalResult = null;
        try {
            ModelNode result = this.dmrClient().execute(modelNode);
            finalResult = this.convertValueToJavaType(result.get("result"));
            if (!(finalResult instanceof List)) {
                return finalResult;
            }
            return this.convertListElements(modelNode.get("address"), (List)finalResult, strProperty);
        }
        catch (IOException e) {
            throw new ELException((Throwable)e);
        }
    }

    public boolean isReadOnly(ELContext elCtx, Object base, Object property) {
        if (base == null) {
            return false;
        }
        if (!(base instanceof ModelNode)) {
            return false;
        }
        elCtx.setPropertyResolved(true);
        ModelNode operation = ((ModelNode)base).clone();
        operation.get("operation").set("read-resource-description");
        try {
            ModelNode result = this.dmrClient().execute(operation);
            String accessType = result.get(new String[]{"result", "attributes", (String)property, "access-type"}).asString();
            return !accessType.equals("read-write");
        }
        catch (IOException e) {
            throw new ELException((Throwable)e);
        }
    }

    public void setValue(ELContext elCtx, Object base, Object property, Object value) {
        if (base == null) {
            return;
        }
        if (!(base instanceof ModelNode)) {
            return;
        }
        elCtx.setPropertyResolved(true);
        String strProperty = (String)property;
        strProperty = this.replaceCharsNotAllowedInEL(strProperty.trim());
        ModelNode operation = (ModelNode)base;
        operation = operation.clone();
        operation.get("name").set(strProperty);
        Class<?> type = this.getType(elCtx, base, property);
        if (value == null || type == null) {
            operation.get("operation").set("undefine-attribute");
        } else {
            operation.get("operation").set("write-attribute");
            this.setValueAttribute(operation, type, value);
        }
        try {
            ModelNode result = this.dmrClient().execute(operation);
            if (this.isOutcomeFailed(result)) {
                throw new DmrOperationFailedException(operation, result);
            }
        }
        catch (IOException e) {
            throw new ELException((Throwable)e);
        }
    }

    private boolean isOutcomeFailed(ModelNode result) {
        String outcome = result.get("outcome").asString();
        return !outcome.equals("success");
    }

    private boolean isPropertyList(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelNode)) {
            return false;
        }
        ModelNode node = (ModelNode)obj;
        if (node.getType() != ModelType.LIST) {
            return false;
        }
        List list = node.asList();
        if (list.isEmpty()) {
            return false;
        }
        for (ModelNode element : list) {
            if (element.getType() == ModelType.PROPERTY) continue;
            return false;
        }
        return true;
    }

    private void setValueAttribute(ModelNode operation, Class type, Object value) {
        ModelNode valueNode = operation.get("value");
        if (type == null) {
            return;
        }
        if (type.isAssignableFrom(ModelNode.class)) {
            valueNode.set((ModelNode)value);
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            valueNode.set((BigDecimal)value);
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            valueNode.set((BigInteger)value);
        }
        if (type.isAssignableFrom(Boolean.class)) {
            valueNode.set(((Boolean)value).booleanValue());
        }
        if (type.isAssignableFrom(byte[].class)) {
            valueNode.set((byte[])value);
        }
        if (type.isAssignableFrom(Double.class)) {
            valueNode.set(((Double)value).doubleValue());
        }
        if (type.isAssignableFrom(Integer.class)) {
            valueNode.set(((Integer)value).intValue());
        }
        if (type.isAssignableFrom(Collection.class)) {
            valueNode.set((Collection)value);
        }
        if (type.isAssignableFrom(Long.class)) {
            valueNode.set(((Long)value).longValue());
        }
        if (type.isAssignableFrom(Object.class)) {
            valueNode.set((ModelNode)value);
        }
        if (type.isAssignableFrom(Property.class)) {
            valueNode.set((Property)value);
        }
        valueNode.set(value.toString());
    }

    private Class<?> convertToJavaType(ModelType type) {
        if (type == ModelType.BIG_DECIMAL) {
            return BigDecimal.class;
        }
        if (type == ModelType.BIG_INTEGER) {
            return BigInteger.class;
        }
        if (type == ModelType.BOOLEAN) {
            return Boolean.class;
        }
        if (type == ModelType.BYTES) {
            return byte[].class;
        }
        if (type == ModelType.DOUBLE) {
            return Double.class;
        }
        if (type == ModelType.INT) {
            return Integer.class;
        }
        if (type == ModelType.LIST) {
            return Collection.class;
        }
        if (type == ModelType.LONG) {
            return Long.class;
        }
        if (type == ModelType.OBJECT) {
            return Object.class;
        }
        if (type == ModelType.PROPERTY) {
            return Property.class;
        }
        if (type == ModelType.STRING) {
            return String.class;
        }
        return null;
    }

    private Object convertValueToJavaType(ModelNode node) {
        if (!node.isDefined()) {
            return null;
        }
        return this.convertValueToJavaType(node, node.getType());
    }

    private Object convertValueToJavaType(ModelNode node, ModelType type) {
        if (!node.isDefined()) {
            return null;
        }
        if (type == ModelType.BIG_DECIMAL) {
            return node.asBigDecimal();
        }
        if (type == ModelType.BIG_INTEGER) {
            return node.asBigInteger();
        }
        if (type == ModelType.BOOLEAN) {
            return node.asBoolean();
        }
        if (type == ModelType.BYTES) {
            return node.asBytes();
        }
        if (type == ModelType.DOUBLE) {
            return node.asDouble();
        }
        if (type == ModelType.INT) {
            return node.asInt();
        }
        if (type == ModelType.LIST) {
            return node.asList();
        }
        if (type == ModelType.LONG) {
            return node.asLong();
        }
        if (type == ModelType.OBJECT) {
            return node.asObject();
        }
        if (type == ModelType.PROPERTY) {
            return node.asProperty();
        }
        if (type == ModelType.STRING) {
            return node.asString();
        }
        if (type == ModelType.TYPE) {
            return node.asType();
        }
        return null;
    }

    private List convertListElements(ModelNode address, List<ModelNode> elements, String property) throws IOException {
        ModelNode rscDesc = new ModelNode();
        rscDesc.get("address").set(address.clone());
        rscDesc.get("operation").set("read-resource-description");
        ModelNode result = this.dmrClient().execute(rscDesc);
        ModelType type = result.get(new String[]{"result", "attributes", property, "value-type"}).asType();
        ArrayList<Object> convertedList = new ArrayList<Object>(elements.size());
        for (ModelNode element : elements) {
            convertedList.add(this.convertValueToJavaType(element, type));
        }
        return convertedList;
    }

    private String replaceCharsNotAllowedInEL(String str) {
        str = str.replace("_dash_", "-");
        str = str.replace("_dot_", ".");
        str = str.replace("_astk_", "*");
        return str;
    }

    private ModelNode addAddress(ModelNode operation, String property) {
        ModelNode op = operation.clone();
        ModelNode address = op.get("address");
        address.add(this.makeAddress(property));
        return op;
    }

    private ModelNode makeAddress(String property) {
        ModelNode address = new ModelNode();
        String lvalue = property.substring(0, property.indexOf("_eq_"));
        String rvalue = property.substring(property.indexOf("_eq_") + 4);
        address.get(lvalue).set(rvalue);
        return address;
    }

    private boolean isAddress(String property) {
        return property.contains("_eq_") || property.equals(ROOT);
    }

    private ModelControllerClient dmrClient() {
        if (isDomain) {
            return domainDmrClient;
        }
        return localDmrClient;
    }

    private Object executeCLI(String command) {
        ModelNode operation = null;
        try {
            operation = cliContext.buildRequest(command);
        }
        catch (CommandFormatException e) {
            throw new ELException((Throwable)e);
        }
        try {
            ModelNode result = this.dmrClient().execute(operation);
            if (this.isOutcomeFailed(result)) {
                throw new DmrOperationFailedException(operation, result);
            }
            ModelNode commandResult = result.get("result");
            if (!commandResult.isDefined()) {
                return result;
            }
            if (commandResult.getType() == ModelType.LIST) {
                return commandResult.asList();
            }
            return commandResult;
        }
        catch (IOException e) {
            throw new ELException((Throwable)e);
        }
    }

    static {
        localDmrClient = ManagementService.getClient();
        domainDmrClient = null;
        ModelNode readLaunchType = new ModelNode();
        readLaunchType.get("address").setEmptyList();
        readLaunchType.get("operation").set("read-attribute");
        readLaunchType.get("name").set("launch-type");
        try {
            ModelNode result = localDmrClient.execute(readLaunchType);
            boolean bl = isDomain = !result.get("result").asString().equals("STANDALONE");
            if (isDomain) {
                InetAddress domainAddress = InetAddress.getByName(System.getProperty("jboss.domain.master.address"));
                int domainPort = Integer.parseInt(System.getProperty("jboss.domain.master.port", "9999"));
                domainDmrClient = ModelControllerClient.Factory.create((InetAddress)domainAddress, (int)domainPort);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            cliContext = CommandContextFactory.getInstance().newCommandContext();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException(e);
        }
    }
}

