/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cliresolver;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.server.Services;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagementService
implements ServiceActivator {
    private static volatile ModelController controller;
    private static volatile ExecutorService executor;

    public static ModelControllerClient getClient() {
        return controller.createClient((Executor)executor);
    }

    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        GetModelControllerService service = new GetModelControllerService();
        context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"management", "client", "getter"}), (Service)service).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, (Injector)service.modelControllerValue).install();
    }

    private class GetModelControllerService
    implements Service<Void> {
        private InjectedValue<ModelController> modelControllerValue = new InjectedValue();

        private GetModelControllerService() {
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }

        public void start(StartContext context) throws StartException {
            executor = Executors.newFixedThreadPool(5, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("ManagementServiceModelControllerClientThread");
                    return t;
                }
            });
            controller = (ModelController)this.modelControllerValue.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(StopContext context) {
            try {
                executor.shutdownNow();
            }
            finally {
                executor = null;
                controller = null;
            }
        }
    }
}

