/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

public class CacheListenerBase {
    private static final int JSESSION_FQN_INDEX = 0;
    private static final int HOSTNAME_FQN_INDEX = 1;
    private static final int WEBAPP_FQN_INDEX = 2;
    protected static final int SESSION_ID_FQN_INDEX = 3;
    private static final int SESSION_FQN_SIZE = 4;
    private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
    protected static final int BUDDY_BACKUP_ROOT_OWNER_SIZE = BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
    protected LocalDistributableSessionManager manager_;
    private String webapp_;
    private String hostname_;

    CacheListenerBase(LocalDistributableSessionManager manager, String hostname, String webapp) {
        this.manager_ = manager;
        this.hostname_ = hostname;
        this.webapp_ = webapp;
    }

    protected boolean isFqnForOurWebapp(Fqn fqn, boolean isBuddy) {
        try {
            if (this.webapp_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 2 : 2)) && this.hostname_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 1 : 1)) && "JSESSION".equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 0 : 0))) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFqnSessionRootSized(Fqn fqn, boolean isBuddy) {
        return fqn.size() == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 4 : 4);
    }

    public static String getIdFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 3 : 3);
    }

    public static boolean isBuddyFqn(Fqn fqn) {
        try {
            return "_BUDDY_BACKUP_".equals(fqn.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static String getBuddyOwner(Fqn fqn) {
        return (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
    }
}

