/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.TimeoutException;

public class JBossCacheWrapper {
    private static final int RETRY = 3;
    private static final String RETRY_FAIL_MSG = "Continued to catch TimeoutException during 3 retry attempts. Giving up.";
    private Cache plainCache_;

    JBossCacheWrapper(Cache cache) {
        this.plainCache_ = cache;
    }

    Map getData(Fqn fqn, boolean gravitate) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (gravitate) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                }
                return this.plainCache_.getData(fqn);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object get(Fqn fqn, String id) {
        return this.get(fqn, id, false);
    }

    Object get(Fqn fqn, String id, boolean gravitate) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (gravitate) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                }
                return this.plainCache_.get(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn fqn, String id, Object value) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, (Object)id, value);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void put(Fqn fqn, Map map) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.put(fqn, map);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    Object remove(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.plainCache_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void remove(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void removeLocal(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.plainCache_.removeNode(fqn);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }

    void evictSubtree(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.plainCache_.evict(fqn, true);
                return;
            }
            catch (TimeoutException e) {
                ex = e;
                continue;
            }
        }
        throw new RuntimeException(RETRY_FAIL_MSG, ex);
    }
}

