/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.jmx.PojoCacheJmxWrapper;
import org.jboss.cache.pojo.jmx.PojoCacheJmxWrapperMBean;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.FieldBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.FieldBasedDistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterConfig;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterDistributedCacheManagerFactory;

public class DistributedCacheManagerFactoryImpl
implements TomcatClusterDistributedCacheManagerFactory {
    public static final String DEFAULT_CLUSTER_NAME = "Tomcat-Cluster";
    public static final String DEFAULT_ISOLATION_LEVEL = "REPEATABLE_READ";
    public static final String DEFAULT_CACHE_MODE = "REPL_ASYNC";
    public static final long DEFAULT_LOCK_TIMEOUT = 15000L;
    public static final String DEFAULT_TM_LOOKUP = BatchModeTransactionManagerLookup.class.getName();
    private TomcatClusterConfig tomcatConfig;
    private MBeanServer mserver;
    private boolean pojoCacheLocal = false;
    private PojoCache pojoCache;
    private Cache plainCache;

    public DistributedCacheManager getDistributedCacheManager(String cacheConfigName) throws ClusteringNotSupportedException {
        return this.plainCache == null ? new JBossCacheService(cacheConfigName) : new JBossCacheService(this.plainCache);
    }

    public FieldBasedDistributedCacheManager getFieldBasedDistributedCacheManager(String cacheConfigName) throws ClusteringNotSupportedException {
        return this.pojoCache == null ? new FieldBasedJBossCacheService(cacheConfigName) : new FieldBasedJBossCacheService(this.pojoCache);
    }

    public TomcatClusterConfig getTomcatClusterConfig() {
        return this.tomcatConfig;
    }

    public void setTomcatClusterConfig(TomcatClusterConfig clusterConfig) {
        this.tomcatConfig = clusterConfig;
    }

    public void start() throws Exception {
        if (this.tomcatConfig != null) {
            this.initializePojoCache();
        }
    }

    public void stop() throws Exception {
        if (this.pojoCache != null) {
            this.pojoCache.stop();
            this.pojoCache.destroy();
            if (this.pojoCacheLocal && this.mserver != null && this.tomcatConfig.getCacheObjectName() != null) {
                this.mserver.unregisterMBean(new ObjectName(this.tomcatConfig.getCacheObjectName()));
            }
        }
    }

    public PojoCache getPojoCache() {
        return this.pojoCache;
    }

    public void setPojoCache(PojoCache pojoCache) {
        this.pojoCache = pojoCache;
        this.plainCache = pojoCache.getCache();
    }

    public Cache getPlainCache() {
        return this.plainCache;
    }

    public void setPlainCache(Cache plainCache) {
        this.plainCache = plainCache;
        this.pojoCache = null;
    }

    public void clearCaches() {
        this.plainCache = null;
        this.pojoCache = null;
    }

    private void initializePojoCache() throws Exception {
        if (this.pojoCache == null) {
            ObjectName objName;
            PojoCacheJmxWrapperMBean pcWrapper = null;
            MBeanServer server = this.tomcatConfig.getMBeanServer();
            String cfgName = this.tomcatConfig.getCacheObjectName();
            ObjectName objectName = objName = cfgName == null ? null : new ObjectName(this.tomcatConfig.getCacheObjectName());
            if (server != null && objName != null && server.isRegistered(objName)) {
                pcWrapper = MBeanServerInvocationHandler.newProxyInstance(server, objName, PojoCacheJmxWrapperMBean.class, false);
            } else {
                File configFile = this.tomcatConfig.getCacheConfigFile();
                String clusterName = this.tomcatConfig.getClusterName();
                if (configFile != null) {
                    pcWrapper = new PojoCacheJmxWrapper(PojoCacheFactory.createCache((String)configFile.getAbsolutePath(), (boolean)false));
                    Configuration config = this.pojoCache.getCache().getConfiguration();
                    if (clusterName != null) {
                        config.setClusterName(clusterName);
                    }
                } else {
                    Configuration config = new Configuration();
                    String channelName = clusterName == null ? DEFAULT_CLUSTER_NAME : clusterName;
                    config.setClusterName(channelName);
                    config.setIsolationLevel(DEFAULT_ISOLATION_LEVEL);
                    config.setCacheMode(DEFAULT_CACHE_MODE);
                    config.setLockAcquisitionTimeout(15000L);
                    config.setTransactionManagerLookupClass(DEFAULT_TM_LOOKUP);
                    pcWrapper = new PojoCacheJmxWrapper(PojoCacheFactory.createCache((Configuration)config, (boolean)false));
                }
                if (server != null && objName != null) {
                    server.registerMBean(pcWrapper, objName);
                }
                this.pojoCacheLocal = true;
            }
            this.setPojoCache(pcWrapper.getPojoCache());
        }
    }
}

