/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.ha.cachemanager;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.CacheConfigsXmlParser;
import org.jboss.cache.config.parsing.RootElementBuilder;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Temporary workaround to JBCACHE-1562
 *
 * @author Brian Stansberry
 * 
 * @version $Revision: 98045 $
 * 
 * @deprecated to be removed when JBCACHE-1562 is fixed
 */
class CacheConfigsParser extends CacheConfigsXmlParser
{
   @Override
   public Map<String, Configuration> parseConfigs(InputStream stream, String fileName)
         throws CloneNotSupportedException
   {
      // loop through all elements in XML.
      Element root = getDocumentRoot(stream);

      NodeList list = root.getElementsByTagName(CONFIG_ROOT);
      if (list == null || list.getLength() == 0)
      {
         // try looking for a QUALIFIED_CONFIG_ROOT
         list = root.getElementsByTagName(QUALIFIED_CONFIG_ROOT);
         if (list == null || list.getLength() == 0)
            throw new ConfigurationException("Can't find " + CONFIG_ROOT + " or " + QUALIFIED_CONFIG_ROOT + " tag");
      }

      Map<String, Configuration> result = new HashMap<String, Configuration>();

      for (int i = 0; i < list.getLength(); i++)
      {
         Node node = list.item(i);
         if (node.getNodeType() != Node.ELEMENT_NODE)
         {
            continue;
         }

         Element element = (Element) node;
         String name = element.getAttribute(CONFIG_NAME);
         if (name == null || name.trim().length() == 0)
            throw new ConfigurationException("Element " + element + " has no name attribute");

         XmlConfigurationParser parser = new XmlConfigurationParser();
         Configuration c = parser.parseElementIgnoringRoot(element);

         // Prove that we can successfully clone it
         c = c.clone();
         result.put(name.trim(), c);
      }

      return result;
   }

   private Element getDocumentRoot(InputStream stream)
   {
      RootElementBuilder rootElementBuilder = new RootElementBuilder(false);
      return rootElementBuilder.readRoot(stream);
   }

}
