/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AttributeBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.SessionBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterConfig;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterDistributedCacheManagerFactory;

public class DistributedCacheManagerFactoryImpl
implements TomcatClusterDistributedCacheManagerFactory {
    public static final String DEFAULT_CLUSTER_NAME = "Tomcat-Cluster";
    public static final String DEFAULT_ISOLATION_LEVEL = "REPEATABLE_READ";
    public static final String DEFAULT_CACHE_MODE = "REPL_ASYNC";
    public static final long DEFAULT_LOCK_TIMEOUT = 15000L;
    public static final String DEFAULT_TM_LOOKUP = BatchModeTransactionManagerLookup.class.getName();
    private TomcatClusterConfig tomcatConfig;
    private boolean cacheLocal = false;
    private Cache<Object, Object> plainCache;

    public DistributedCacheManager getDistributedCacheManager(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        ReplicationGranularity granularity = Util.getReplicationGranularity(localManager);
        switch (granularity) {
            case SESSION: {
                return this.plainCache == null ? new SessionBasedJBossCacheService(localManager) : new SessionBasedJBossCacheService(localManager, this.plainCache);
            }
            case ATTRIBUTE: {
                return this.plainCache == null ? new AttributeBasedJBossCacheService(localManager) : new AttributeBasedJBossCacheService(localManager, this.plainCache);
            }
        }
        throw new IllegalStateException("Unknown ReplicationGranularity " + granularity);
    }

    public TomcatClusterConfig getTomcatClusterConfig() {
        return this.tomcatConfig;
    }

    public void setTomcatClusterConfig(TomcatClusterConfig clusterConfig) {
        this.tomcatConfig = clusterConfig;
    }

    public void start() throws Exception {
        if (this.tomcatConfig != null) {
            this.initializeCache();
        }
    }

    public void stop() throws Exception {
        if (this.plainCache != null) {
            this.plainCache.stop();
            this.plainCache.destroy();
            if (this.cacheLocal && this.tomcatConfig.getMBeanServer() != null && this.tomcatConfig.getCacheObjectName() != null) {
                this.tomcatConfig.getMBeanServer().unregisterMBean(new ObjectName(this.tomcatConfig.getCacheObjectName()));
            }
        }
    }

    public Cache<Object, Object> getPlainCache() {
        return this.plainCache;
    }

    public void setPlainCache(Cache<Object, Object> plainCache) {
        this.plainCache = plainCache;
    }

    public void clearCaches() {
        this.plainCache = null;
    }

    private void initializeCache() throws Exception {
        if (this.plainCache == null) {
            ObjectName objName;
            CacheJmxWrapper pcWrapper = null;
            MBeanServer server = this.tomcatConfig.getMBeanServer();
            String cfgName = this.tomcatConfig.getCacheObjectName();
            ObjectName objectName = objName = cfgName == null ? null : new ObjectName(this.tomcatConfig.getCacheObjectName());
            if (server != null && objName != null && server.isRegistered(objName)) {
                pcWrapper = MBeanServerInvocationHandler.newProxyInstance(server, objName, CacheJmxWrapper.class, false);
            } else {
                File configFile = this.tomcatConfig.getCacheConfigFile();
                String clusterName = this.tomcatConfig.getClusterName();
                if (configFile != null) {
                    pcWrapper = new CacheJmxWrapper(DefaultCacheFactory.getInstance().createCache(configFile.getAbsolutePath(), false));
                    if (clusterName != null) {
                        pcWrapper.getCache().getConfiguration().setClusterName(clusterName);
                    }
                } else {
                    Configuration config = new Configuration();
                    String channelName = clusterName == null ? DEFAULT_CLUSTER_NAME : clusterName;
                    config.setClusterName(channelName);
                    config.setIsolationLevel(DEFAULT_ISOLATION_LEVEL);
                    config.setCacheMode(DEFAULT_CACHE_MODE);
                    config.setLockAcquisitionTimeout(15000L);
                    config.setTransactionManagerLookupClass(DEFAULT_TM_LOOKUP);
                    pcWrapper = new CacheJmxWrapper(DefaultCacheFactory.getInstance().createCache(config, false));
                }
                if (server != null && objName != null) {
                    server.registerMBean(pcWrapper, objName);
                }
                this.cacheLocal = true;
            }
            this.setPlainCache((Cache<Object, Object>)pcWrapper.getCache());
        }
    }
}

