/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso.jbc;

import java.io.Serializable;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.web.tomcat.service.sso.spi.FullyQualifiedSessionId;
import org.jboss.web.tomcat.service.sso.spi.SSOClusterManager;
import org.jboss.web.tomcat.service.sso.spi.SSOCredentials;
import org.jboss.web.tomcat.service.sso.spi.SSOLocalManager;
import org.jgroups.Address;

@CacheListener
public final class JBossCacheSSOClusterManager
implements SSOClusterManager {
    private static final String CREDENTIALS = "credentials";
    private static final String SSO = "SSO";
    private static final String SESSIONS = "sessions";
    private static final String KEY = "key";
    public static final String DEFAULT_THREAD_POOL_NAME = "jboss.system:service=ThreadPool";
    public static final String DEFAULT_CACHE_NAME = "clustered-sso";
    public static final String LEGACY_CACHE_NAME = "jboss.cache:service=TomcatClusteringCache";
    private ThreadLocal<String> beingLocallyAdded = new ThreadLocal();
    private ThreadLocal<String> beingLocallyRemoved = new ThreadLocal();
    private ThreadLocal<String> beingRemotelyRemoved = new ThreadLocal();
    private String cacheName = "clustered-sso";
    private ObjectName cacheObjectName = null;
    private Cache<Object, Object> cache = null;
    private TransactionManager tm = null;
    private String threadPoolName = "jboss.system:service=ThreadPool";
    private ThreadPool threadPool;
    private Logger log = Logger.getLogger((String)this.getClass().getName());
    private boolean registeredAsListener = false;
    private MBeanServer server = null;
    private SSOLocalManager ssoValve = null;
    private boolean started = false;
    private boolean treeCacheAvailable = false;
    private boolean missingCacheErrorLogged = false;
    private Serializable localAddress = null;
    private Set<Object> currentView = new HashSet<Object>();
    private Object cleanupMutex = new Object();

    public JBossCacheSSOClusterManager() {
    }

    public JBossCacheSSOClusterManager(MBeanServer server) {
        this.server = server;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public boolean isUsingThreadPool() {
        return this.threadPool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String ssoId, FullyQualifiedSessionId sessionId) {
        if (ssoId == null || sessionId == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addSession(): adding Session " + sessionId.getSessionId() + " to cached session set for SSO " + ssoId));
        }
        Fqn<Serializable> fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        try {
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            this.putInTreeCache(fqn, sessionId, null);
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.log.error((Object)("caught exception adding session " + sessionId.getSessionId() + " to SSO id " + ssoId), (Throwable)e);
        }
        finally {
            if (doTx) {
                this.endTransaction();
            }
        }
    }

    public SSOLocalManager getSSOLocalManager() {
        return this.ssoValve;
    }

    public void setSSOLocalManager(SSOLocalManager localManager) {
        this.ssoValve = localManager;
        if (this.ssoValve != null) {
            String poolName;
            String config;
            if (this.server == null) {
                this.server = this.ssoValve.getMBeanServer();
            }
            if ((config = this.ssoValve.getCacheConfig()) != null) {
                this.cacheName = config;
            }
            if ((poolName = this.ssoValve.getThreadPoolName()) != null) {
                this.threadPoolName = poolName;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingLocallyRemoved.get())) {
            return;
        }
        this.beingLocallyRemoved.set(ssoId);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering logout of SSO " + ssoId + " in clustered cache"));
        }
        Fqn<String> fqn = this.getSingleSignOnFqn(ssoId);
        try {
            this.removeFromTreeCache(fqn, false);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to remove node " + fqn.toString() + " from TreeCache"), (Throwable)e);
        }
        finally {
            this.beingLocallyRemoved.set(null);
        }
    }

    public SSOCredentials lookup(String ssoId) {
        if (!this.checkTreeCacheAvailable()) {
            return null;
        }
        SSOCredentials credentials = null;
        Fqn<String> fqn = this.getCredentialsFqn(ssoId);
        try {
            credentials = (SSOCredentials)this.getFromTreeCache(fqn, KEY);
        }
        catch (Exception e) {
            this.log.error((Object)("caught exception looking up SSOCredentials for SSO id " + ssoId), (Throwable)e);
        }
        return credentials;
    }

    public void register(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Registering SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String ssoId, FullyQualifiedSessionId sessionId) {
        if (ssoId == null || sessionId == null) {
            return;
        }
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (ssoId.equals(this.beingRemotelyRemoved.get())) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeSession(): removing Session " + sessionId.getSessionId() + " from cached session set for SSO " + ssoId));
        }
        Fqn<Serializable> fqn = this.getSessionsFqn(ssoId);
        boolean doTx = false;
        boolean removing = false;
        try {
            Set<Object> keys;
            if (this.tm == null) {
                this.configureFromCache();
            }
            if (this.tm.getTransaction() == null) {
                doTx = true;
            }
            if (doTx) {
                this.tm.begin();
            }
            if ((keys = this.getSessionKeys(ssoId)).contains(sessionId)) {
                if (keys.size() == 1) {
                    this.removeFromTreeCache(fqn, false);
                } else {
                    this.removeFromTreeCache(fqn, sessionId);
                }
            }
        }
        catch (Exception e) {
            try {
                if (doTx) {
                    this.tm.setRollbackOnly();
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            this.log.error((Object)("caught exception removing session " + sessionId.getSessionId() + " from SSO id " + ssoId), (Throwable)e);
        }
        finally {
            try {
                if (removing) {
                    this.beingLocallyRemoved.set(null);
                }
            }
            finally {
                if (doTx) {
                    this.endTransaction();
                }
            }
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        if (!this.checkTreeCacheAvailable()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updating credentials for SSO " + ssoId + " in clustered cache"));
        }
        this.storeSSOData(ssoId, authType, username, password);
    }

    @NodeRemoved
    public void nodeRemoved(NodeRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        Fqn fqn = event.getFqn();
        String ssoId = this.getIdFromFqn((Fqn<Serializable>)fqn);
        if (ssoId == null) {
            return;
        }
        if (fqn.size() == 2) {
            if (!ssoId.equals(this.beingLocallyRemoved.get())) {
                this.handleRemoteInvalidation(ssoId);
            }
        } else if (fqn.size() == 4) {
            this.handlePeerRemoval(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public synchronized void viewChange(ViewChangedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.log.debug((Object)("Received ViewChangedEvent " + event));
        HashSet<Object> oldMembers = new HashSet<Object>(this.currentView);
        Set<Object> set = this.currentView;
        synchronized (set) {
            this.currentView.clear();
            this.currentView.addAll(event.getNewView().getMembers());
            if (this.localAddress == null || !this.currentView.contains(this.localAddress)) {
                return;
            }
            oldMembers.removeAll(this.currentView);
        }
        if (oldMembers.size() > 0) {
            this.log.debug((Object)("Members have been removed; will launch cleanup task. Dead members: " + oldMembers));
            this.launchSSOCleaner(false);
        }
    }

    private void launchSSOCleaner(boolean notifyIfEmpty) {
        SSOCleanerTask cleaner = new SSOCleanerTask(notifyIfEmpty);
        if (this.threadPool != null) {
            this.threadPool.run((Runnable)cleaner);
        } else {
            Thread t = new Thread((Runnable)cleaner, "ClusteredSSOCleaner");
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteInvalidation(String ssoId) {
        this.beingRemotelyRemoved.set(ssoId);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received a node removed message for SSO " + ssoId));
            }
            this.ssoValve.deregister(ssoId);
        }
        finally {
            this.beingRemotelyRemoved.set(null);
        }
    }

    private void handlePeerRemoval(String ssoId) {
        try {
            Set<Object> peers = this.getSSOPeers(ssoId);
            if (peers.size() == 0) {
                this.ssoValve.notifySSOEmpty(ssoId);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Caught exception checking if " + ssoId + " is empty"), (Throwable)e);
        }
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        Fqn fqn = event.getFqn();
        String type = this.getTypeFromFqn((Fqn<Serializable>)fqn);
        if (CREDENTIALS.equals(type)) {
            Map nodeData = event.getData();
            this.handleCredentialUpdate(this.getIdFromFqn((Fqn<Serializable>)fqn), nodeData);
        } else if (SESSIONS.equals(type)) {
            this.handleSessionSetChange((Fqn<Serializable>)fqn);
        }
    }

    private void handleCredentialUpdate(String ssoId, Map<Object, Object> nodeData) {
        if (ssoId.equals(this.beingLocallyAdded.get())) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("received a credentials modified message for SSO " + ssoId));
        }
        try {
            SSOCredentials data = (SSOCredentials)nodeData.get(KEY);
            if (data != null) {
                this.ssoValve.remoteUpdate(ssoId, data);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("failed to update credentials for SSO " + ssoId), (Throwable)e);
        }
    }

    private void handleSessionSetChange(Fqn<Serializable> fqn) {
        if (fqn.size() != 4) {
            return;
        }
        this.ssoValve.notifySSONotEmpty(this.getIdFromFqn(fqn));
    }

    public void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("JBossCacheSSOClusterManager already Started");
        }
        this.initThreadPool();
        if (this.isCacheAvailable(true)) {
            this.integrateWithCache();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("JBossCacheSSOClusterManager not Started");
        }
        this.removeAsCacheListener();
        this.started = false;
    }

    public int getSessionCount(String ssoId) throws Exception {
        int count = 0;
        Set<Object> peers = this.getSSOPeers(ssoId);
        for (Object peer : peers) {
            Set<Object> ids = this.getSessionKeys(ssoId, (Serializable)peer);
            count += ids.size();
        }
        return count;
    }

    private Object getFromTreeCache(Fqn<?> fqn, String key) throws Exception {
        return this.cache.get(fqn, (Object)key);
    }

    private Set<String> getSSOIds() throws Exception {
        Fqn ssoRootFqn = Fqn.fromElements((Object[])new String[]{SSO});
        Node ssoRoot = this.cache.getRoot().getChild(ssoRootFqn);
        HashSet<String> result = ssoRoot == null ? new HashSet() : ssoRoot.getChildrenNames();
        return result;
    }

    private Set<Object> getSSOPeers(String ssoId) throws Exception {
        Fqn<String> fqn = this.getSessionRootFqn(ssoId);
        Node ssoRoot = this.cache.getRoot().getChild(fqn);
        HashSet<Object> result = ssoRoot == null ? new HashSet() : ssoRoot.getChildrenNames();
        return result;
    }

    private Fqn<String> getCredentialsFqn(String ssoid) {
        return Fqn.fromElements((Object[])new String[]{SSO, ssoid, CREDENTIALS});
    }

    private Fqn<String> getSessionRootFqn(String ssoId) {
        return Fqn.fromElements((Object[])new String[]{SSO, ssoId, SESSIONS});
    }

    private Fqn<Serializable> getSessionsFqn(String ssoid) {
        return this.getSessionsFqn(ssoid, this.localAddress);
    }

    private Fqn<Serializable> getSessionsFqn(String ssoid, Serializable address) {
        return Fqn.fromElements((Object[])new Serializable[]{SSO, ssoid, SESSIONS, address});
    }

    private Fqn<String> getSingleSignOnFqn(String ssoid) {
        return Fqn.fromElements((Object[])new String[]{SSO, ssoid});
    }

    private String getIdFromFqn(Fqn<Serializable> fqn) {
        String id = null;
        if (fqn.size() > 1 && SSO.equals(fqn.get(0))) {
            id = (String)fqn.get(1);
        }
        return id;
    }

    private String getTypeFromFqn(Fqn<Serializable> fqn) {
        String type = null;
        if (fqn.size() > 2 && SSO.equals(fqn.get(0))) {
            type = (String)fqn.get(2);
        }
        return type;
    }

    private Set<Object> getSessionKeys(String ssoId) {
        return this.getSessionKeys(ssoId, this.localAddress);
    }

    private Set<Object> getSessionKeys(String ssoId, Serializable peer) {
        Fqn<Serializable> fqn = this.getSessionsFqn(ssoId, peer);
        HashSet<Object> keys = null;
        Node sessions = this.cache.getRoot().getChild(fqn);
        keys = sessions != null ? sessions.getKeys() : new HashSet<Object>();
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFromCache() throws Exception {
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (this.tm == null) {
            throw new IllegalStateException("Cache does not have a transaction manager; please configure a valid TransactionManagerLookupClass");
        }
        Address address = this.cache.getLocalAddress();
        if (address != null) {
            this.localAddress = address;
        } else if (Configuration.CacheMode.LOCAL == this.cache.getConfiguration().getCacheMode()) {
            this.localAddress = "LOCAL";
        } else {
            throw new IllegalStateException("Cannot get local address from cache");
        }
        this.log.debug((Object)("Local address is " + this.localAddress));
        Set<Object> set = this.currentView;
        synchronized (set) {
            this.currentView.clear();
            List members = this.cache.getMembers();
            if (members != null) {
                this.currentView.addAll(members);
                this.log.debug((Object)("Current view is " + this.currentView));
            }
        }
    }

    private void endTransaction() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new NestedRuntimeException("JBossCacheSSOClusterManager.endTransaction(): ", (Throwable)e);
        }
    }

    private MBeanServer getMBeanServer() {
        if (this.server == null && this.ssoValve != null) {
            this.server = this.ssoValve.getMBeanServer();
        }
        return this.server;
    }

    private synchronized boolean isCacheAvailable(boolean forceCheck) {
        if (forceCheck || !this.treeCacheAvailable) {
            boolean available;
            String configuredCacheName = this.getCacheName();
            boolean bl = available = configuredCacheName != null;
            if (available) {
                try {
                    CacheManager cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
                    available = cm.getConfigurationNames().contains(configuredCacheName);
                }
                catch (IllegalStateException ise) {
                    this.log.debug((Object)"No CacheManager available");
                    available = false;
                }
                if (!available && this.getMBeanServer() != null) {
                    String onameStr = configuredCacheName;
                    if (DEFAULT_CACHE_NAME.equals(configuredCacheName)) {
                        onameStr = LEGACY_CACHE_NAME;
                    }
                    try {
                        ObjectName oname = new ObjectName(onameStr);
                        Set<ObjectInstance> s = this.getMBeanServer().queryMBeans(oname, null);
                        if (s.size() > 0) {
                            available = true;
                            this.cacheObjectName = oname;
                            this.cacheName = onameStr;
                        }
                    }
                    catch (JMException e) {
                        // empty catch block
                    }
                }
                if (available) {
                    try {
                        if (this.started) {
                            this.integrateWithCache();
                        }
                        this.setMissingCacheErrorLogged(false);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Caught exception configuring from cache " + this.cacheName), (Throwable)e);
                        available = false;
                    }
                }
            }
            this.treeCacheAvailable = available;
        }
        return this.treeCacheAvailable;
    }

    private boolean checkTreeCacheAvailable() {
        boolean avail = this.isCacheAvailable(false);
        if (!avail) {
            this.logMissingCacheError();
        }
        return avail;
    }

    private void putInTreeCache(Fqn<?> fqn, Object key, Object data) throws Exception {
        this.cache.put(fqn, key, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integrateWithCache() throws Exception {
        if (this.cache == null) {
            ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
            ContextClassLoaderSwitcher.SwitchContext switchContext = switcher.getSwitchContext(this.getClass().getClassLoader());
            try {
                if (this.cacheObjectName == null) {
                    CacheManager cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
                    this.cache = cm.getCache(this.cacheName, true);
                } else if (this.server != null) {
                    MBeanAttributeInfo[] attrs;
                    MBeanInfo info = this.server.getMBeanInfo(this.cacheObjectName);
                    for (MBeanAttributeInfo attr : attrs = info.getAttributes()) {
                        Cache unchecked;
                        if (!"Cache".equals(attr.getName())) continue;
                        this.cache = unchecked = (Cache)this.getMBeanServer().getAttribute(this.cacheObjectName, "Cache");
                        break;
                    }
                } else {
                    throw new IllegalStateException("No JBoss Cache available under name " + this.cacheName);
                }
                if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
                    this.cache.start();
                }
            }
            finally {
                switchContext.reset();
            }
            this.configureFromCache();
            this.activateCacheRegion();
            this.registerAsCacheListener();
            this.launchSSOCleaner(true);
            this.log.debug((Object)("Successfully integrated with cache service " + this.cacheName));
        }
    }

    private void activateCacheRegion() throws Exception {
        if (this.cache.getConfiguration().isInactiveOnStartup() && this.cache.getConfiguration().isUseRegionBasedMarshalling()) {
            Region region = this.cache.getRegion(Fqn.fromElements((Object[])new String[]{SSO}), true);
            try {
                region.activate();
            }
            catch (RegionNotEmptyException e) {
                this.log.debug((Object)"SSO region already active", (Throwable)e);
            }
        }
    }

    private void registerAsCacheListener() throws Exception {
        this.cache.addCacheListener((Object)this);
        this.registeredAsListener = true;
    }

    private void removeAsCacheListener() throws Exception {
        if (this.registeredAsListener && this.cache != null) {
            this.cache.removeCacheListener((Object)this);
            this.registeredAsListener = false;
        }
    }

    private void removeFromTreeCache(Fqn<?> fqn, boolean localOnly) throws Exception {
        if (localOnly) {
            InvocationContext ctx = this.cache.getInvocationContext();
            Option option = new Option();
            option.setCacheModeLocal(true);
            ctx.setOptionOverrides(option);
        }
        this.cache.removeNode(fqn);
    }

    private void removeFromTreeCache(Fqn<Serializable> fqn, Object key) throws Exception {
        this.cache.remove(fqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSSOData(String ssoId, String authType, String username, String password) {
        SSOCredentials data = new SSOCredentials(authType, username, password);
        this.beingLocallyAdded.set(ssoId);
        try {
            this.putInTreeCache(this.getCredentialsFqn(ssoId), KEY, data);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception attempting to add TreeCache nodes for SSO " + ssoId), (Throwable)e);
        }
        finally {
            this.beingLocallyAdded.set(null);
        }
    }

    private void initThreadPool() {
        if (this.threadPoolName != null && this.getMBeanServer() != null) {
            try {
                ObjectName on = new ObjectName(this.threadPoolName);
                this.threadPool = (ThreadPool)this.server.getAttribute(on, "Instance");
                this.log.debug((Object)("Using ThreadPool at " + this.threadPoolName + " to clean dead members"));
            }
            catch (JMException e) {
                this.log.info((Object)("Unable to access ThreadPool at " + this.threadPoolName + " -- will use individual threads for cleanup work"));
                this.log.debug((Object)("Failure to access ThreadPool due to: " + e));
            }
        } else {
            this.log.debug((Object)"No ThreadPool configured -- will use individual threads for cleanup work");
        }
    }

    private boolean isMissingCacheErrorLogged() {
        return this.missingCacheErrorLogged;
    }

    private void setMissingCacheErrorLogged(boolean missingCacheErrorLogged) {
        this.missingCacheErrorLogged = missingCacheErrorLogged;
    }

    private void logMissingCacheError() {
        StringBuffer msg = new StringBuffer("Cannot find TreeCache using ");
        msg.append(this.getCacheName());
        msg.append(" -- TreeCache must be started before ClusteredSingleSignOn ");
        msg.append("can handle requests");
        if (this.isMissingCacheErrorLogged()) {
            this.log.warn((Object)msg);
        } else {
            this.log.error((Object)msg);
            this.setMissingCacheErrorLogged(true);
        }
    }

    private class SSOCleanerTask
    implements Runnable {
        private final boolean checkForEmpty;

        private SSOCleanerTask(boolean checkForEmpty) {
            this.checkForEmpty = checkForEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = JBossCacheSSOClusterManager.this.cleanupMutex;
            synchronized (object) {
                try {
                    if (JBossCacheSSOClusterManager.this.tm == null) {
                        JBossCacheSSOClusterManager.this.configureFromCache();
                    }
                    Set ids = JBossCacheSSOClusterManager.this.getSSOIds();
                    for (String sso : ids) {
                        this.cleanSSO(sso);
                    }
                }
                catch (Exception e) {
                    JBossCacheSSOClusterManager.this.log.error((Object)"Caught exception cleaning sessions from dead cluster members from SSOs ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanSSO(String ssoId) {
            block18: {
                boolean doTx = false;
                try {
                    Set peers;
                    if (JBossCacheSSOClusterManager.this.tm.getTransaction() == null) {
                        doTx = true;
                    }
                    if (doTx) {
                        JBossCacheSSOClusterManager.this.tm.begin();
                    }
                    if ((peers = JBossCacheSSOClusterManager.this.getSSOPeers(ssoId)) != null && peers.size() > 0) {
                        for (Object peer : peers) {
                            boolean alive = true;
                            Set set = JBossCacheSSOClusterManager.this.currentView;
                            synchronized (set) {
                                alive = JBossCacheSSOClusterManager.this.currentView.contains(peer);
                            }
                            if (alive) continue;
                            if (JBossCacheSSOClusterManager.this.log.isTraceEnabled()) {
                                JBossCacheSSOClusterManager.this.log.trace((Object)("Removing peer " + peer + " from SSO " + ssoId));
                            }
                            Fqn fqn = JBossCacheSSOClusterManager.this.getSessionsFqn(ssoId, (Serializable)peer);
                            JBossCacheSSOClusterManager.this.removeFromTreeCache(fqn, true);
                        }
                        break block18;
                    }
                    if (this.checkForEmpty) {
                        JBossCacheSSOClusterManager.this.ssoValve.notifySSOEmpty(ssoId);
                    }
                }
                catch (Exception e) {
                    try {
                        if (doTx) {
                            JBossCacheSSOClusterManager.this.tm.setRollbackOnly();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    JBossCacheSSOClusterManager.this.log.error((Object)("caught exception cleaning dead members from SSO " + ssoId), (Throwable)e);
                }
                finally {
                    if (doTx) {
                        JBossCacheSSOClusterManager.this.endTransaction();
                    }
                }
            }
        }
    }
}

