/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.jbc;

import org.jboss.cache.Cache;
import org.jboss.cache.transaction.BatchModeTransactionManagerLookup;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.AttributeBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.SessionBasedJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedCacheManagerFactoryImpl
implements DistributedCacheManagerFactory {
    public static final String DEFAULT_CLUSTER_NAME = "Tomcat-Cluster";
    public static final String DEFAULT_ISOLATION_LEVEL = "REPEATABLE_READ";
    public static final String DEFAULT_CACHE_MODE = "REPL_ASYNC";
    public static final long DEFAULT_LOCK_TIMEOUT = 15000L;
    public static final String DEFAULT_TM_LOOKUP = BatchModeTransactionManagerLookup.class.getName();
    private Cache<Object, Object> plainCache;

    public DistributedCacheManager getDistributedCacheManager(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        ReplicationGranularity granularity = Util.getReplicationGranularity(localManager);
        switch (granularity) {
            case SESSION: {
                return this.plainCache == null ? new SessionBasedJBossCacheService(localManager) : new SessionBasedJBossCacheService(localManager, this.plainCache);
            }
            case ATTRIBUTE: {
                return this.plainCache == null ? new AttributeBasedJBossCacheService(localManager) : new AttributeBasedJBossCacheService(localManager, this.plainCache);
            }
        }
        throw new IllegalStateException("Unknown ReplicationGranularity " + granularity);
    }

    public void stop() throws Exception {
        if (this.plainCache != null) {
            this.plainCache.stop();
            this.plainCache.destroy();
        }
    }

    public Cache<Object, Object> getPlainCache() {
        return this.plainCache;
    }

    public void setPlainCache(Cache<Object, Object> plainCache) {
        this.plainCache = plainCache;
    }

    public void clearCaches() {
        this.plainCache = null;
    }
}

