/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.ha.framework.server.spi;

import org.jgroups.ChannelFactory;

/**
 * Handles basic lifecycle operations on <code>HAPartition</code>'s cache without 
 * exposing the cache and introducing a dependency on JBoss Cache. Purpose is
 * to allow an <code>HAPartition</code> to obtain information about a cache's
 * channel in order to allow it to create a channel with the same configuration.
 * That is important when some services use both a cache and <code>HAPartition</code>
 * and thus want compatible channels for both the cache and the partition.
 * <p>
 * Assumption is that an implementation of this interface would work with an 
 * <code>org.jboss.cache.CacheManager</code> as a
 * source of its cache, but an implemenation could work otherwise.
 * </p>
 * 
 * @author Brian Stansberry
 */
@SuppressWarnings("deprecation")
public interface HAPartitionCacheHandler
{
   /**
    * Instructs this handler to acquire a reference to the cache.
    * 
    * @throws Exception
    */
   void acquireCache() throws Exception;
   
   /**
    * Instructs this handler to start the cache previously obtained via
    * {@link #acquireCache()}.
    * 
    * @throws Exception
    */
   void startCache() throws Exception;
   
   /**
    * Instructs this handler to release any reference to the cache.
    * 
    * @throws Exception
    */
   void releaseCache() throws Exception;
   
   /**
    * Gets the name of the cache's configuration.
    * 
    * @return the name of the cache configuration
    */
   String getCacheConfigName();
   
   /**
    * Gets the name of cache's JGroups protocol stack configuration.
    * 
    * @return the name of the protocol stack configuration
    */
   String getChannelStackName();   
   
   /**
    * Gets the {@link ChannelFactory} from which the cache obtains
    * its <code>Channel</code>.
    * 
    * @return the channel factory.
    */
   ChannelFactory getCacheChannelFactory();   
}
