/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.jbpm;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.provider.DataPropertyFormatterImpl;

@Install
public class jBPMDataPropertyFormatter
extends DataPropertyFormatterImpl {
    public String[] getSupportedPropertyIds() {
        return new String[]{"duration", "status"};
    }

    public String formatValue(String propertyId, Object value, Locale l) {
        String result = null;
        Method m = null;
        try {
            m = ((Object)((Object)this)).getClass().getMethod("formatValue_" + propertyId, Object.class, Locale.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            if (m != null) {
                result = (String)m.invoke((Object)this, value, l);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        return super.formatValue(propertyId, value, l);
    }

    public String formatValue_duration(Object value, Locale l) throws Exception {
        if (value == null || !(value instanceof Number)) {
            return "---";
        }
        Number lengthInSeconds = (Number)value;
        long millis = lengthInSeconds.longValue() * 1000L;
        if (millis < 0L) {
            millis = 0L;
        }
        return this.formatElapsedTime(millis, l);
    }

    public String formatValue_status(Object value, Locale l) throws Exception {
        try {
            if (value == null) {
                return "---";
            }
            if (value instanceof List) {
                return null;
            }
            ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.jbpm.messages", l);
            return i18n.getString("status." + value.toString());
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    public String formatElapsedTime(long millis, Locale l) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.jbpm.messages", l);
        String pattern = "ellapsedtime.hours";
        if ((days %= 7L) > 0L) {
            pattern = "ellapsedtime.days";
        }
        if (weeks > 0L) {
            pattern = "ellapsedtime.weeks";
        }
        return MessageFormat.format(i18n.getString(pattern), new Long(seconds), new Long(minutes), new Long(hours), new Long(days), new Long(weeks));
    }
}

