/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.csv.CSVDataSet;
import org.jboss.dashboard.provider.AbstractDataLoader;
import org.jboss.dashboard.provider.DataProvider;

public class CSVDataLoader
extends AbstractDataLoader {
    protected String csvSeparatedBy;
    protected String csvQuoteChar;
    protected String csvEscapeChar;
    protected String csvDatePattern;
    protected String csvNumberPattern;
    protected String fileURL;
    protected File csvProviderFile;

    public boolean isReady() {
        return this.getFileURL() != null;
    }

    public DataSet load(DataProvider provider) throws Exception {
        if (StringUtils.isBlank((String)this.fileURL)) {
            throw new IllegalStateException("CSV file URL has not been specified.");
        }
        String filePath = this.calculateUrl(this.getFileURL());
        InputStream in = null;
        if (this.getFileURL().indexOf("$APPLICATION_DIR") != -1) {
            in = new FileInputStream(filePath.replace("file://", ""));
        } else {
            URL url = new URL(filePath);
            in = url.openStream();
        }
        return this.load(provider, in);
    }

    public DataSet load(DataProvider provider, InputStream is) throws Exception {
        CSVDataSet newDs = this.create(provider, is);
        newDs.load();
        return newDs;
    }

    public CSVDataSet create(DataProvider provider, InputStream in) throws Exception {
        int len;
        File f = File.createTempFile("csv_temp.", ".csv");
        f.deleteOnExit();
        byte[] buf = new byte[512];
        FileOutputStream fout = new FileOutputStream(f);
        while ((len = in.read(buf)) != -1) {
            fout.write(buf, 0, len);
        }
        fout.close();
        in.close();
        this.setCsvProviderFile(f);
        return new CSVDataSet(provider, this);
    }

    public String getCsvSeparatedBy() {
        return this.csvSeparatedBy;
    }

    public void setCsvSeparatedBy(String csvSeparatedBy) {
        this.csvSeparatedBy = csvSeparatedBy;
    }

    public String getCsvQuoteChar() {
        return this.csvQuoteChar;
    }

    public void setCsvQuoteChar(String csvQuoteChar) {
        this.csvQuoteChar = csvQuoteChar;
    }

    public String getCsvEscapeChar() {
        return this.csvEscapeChar;
    }

    public void setCsvEscapeChar(String csvEscapeChar) {
        this.csvEscapeChar = csvEscapeChar;
    }

    public String getCsvDatePattern() {
        return this.csvDatePattern;
    }

    public void setCsvDatePattern(String csvDatePattern) {
        this.csvDatePattern = csvDatePattern;
    }

    public String getCsvNumberPattern() {
        return this.csvNumberPattern;
    }

    public void setCsvNumberPattern(String csvNumberPattern) {
        this.csvNumberPattern = csvNumberPattern;
    }

    public char getCsvNumberGroupSeparator() {
        if (this.csvNumberPattern.length() < 2) {
            return ',';
        }
        return this.csvNumberPattern.charAt(1);
    }

    public char getCsvNumberDecimalSeparator() {
        if (this.csvNumberPattern.length() < 6) {
            return '.';
        }
        return this.csvNumberPattern.charAt(5);
    }

    public File getCsvProviderFile() {
        return this.csvProviderFile;
    }

    public void setCsvProviderFile(File csvProviderFile) {
        this.csvProviderFile = csvProviderFile;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    protected String calculateUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replace("$APPLICATION_DIR", String.valueOf(Application.lookup().getBaseAppDirectory()));
    }
}

