/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.csv;

import java.io.InputStream;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.DataProviderServices;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetManager;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.DataProviderManager;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.test.ShrinkWrapHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CSVDataSetTest {
    @Inject
    protected BeanManager beanManager;
    @Inject
    protected DataProviderManager dataProviderManager;
    protected DataSetManager dataSetManager;
    protected DataSet dataSet;
    protected DataProviderType dataPoviderType;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
        this.dataSetManager = DataProviderServices.lookup().getDataSetManager();
        this.dataPoviderType = this.dataProviderManager.getProviderTypeByUid("csv");
        DataProvider dataProvider = this.dataProviderManager.createDataProvider();
        CSVDataLoader csvDataLoader = (CSVDataLoader)this.dataPoviderType.createDataLoader();
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("data.csv");
        this.dataSet = csvDataLoader.load(dataProvider, dataStream);
        this.dataSetManager.registerDataSet(dataProvider, this.dataSet);
    }

    @Test
    public void checkDataSet() {
        Assertions.assertThat((Object)this.dataSet).isNotNull();
        Assertions.assertThat((Object)this.dataProviderManager).isNotNull();
        Assertions.assertThat((this.dataProviderManager.getDataProviderTypes().length > 0 ? 1 : 0) != 0);
        Assertions.assertThat((Object)this.dataPoviderType).isNotNull();
        Assertions.assertThat((this.dataSet.getProperties().length > 0 ? 1 : 0) != 0);
        Assertions.assertThat((this.dataSet.getRowCount() == 50 ? 1 : 0) != 0);
    }
}

