/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.csv;

import java.io.InputStream;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.DataProviderServices;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetException;
import org.jboss.dashboard.dataset.DataSetSettings;
import org.jboss.dashboard.profiler.memory.MemoryProfiler;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.DataProviderManager;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.provider.csv.CompositeInputStream;
import org.jboss.dashboard.test.ShrinkWrapHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class CSVPerformanceTest {
    private static transient Logger log = LoggerFactory.getLogger((String)CSVPerformanceTest.class.getName());
    @Inject
    protected BeanManager beanManager;
    @Inject
    protected DataProviderManager dataProviderManager;
    @Inject
    protected MemoryProfiler memoryProfiler;
    protected DataProvider dataProvider;
    protected CSVDataLoader dataLoader;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
        DataProviderType dataPoviderType = this.dataProviderManager.getProviderTypeByUid("csv");
        this.dataProvider = this.dataProviderManager.createDataProvider();
        this.dataLoader = (CSVDataLoader)dataPoviderType.createDataLoader();
    }

    @Test
    public void test500Rows() throws Exception {
        DataSetSettings dataSetSettings = DataProviderServices.lookup().getDataSetSettings();
        dataSetSettings.setMaxDataSetSizeInBytes(0x100000L);
        dataSetSettings.setMaxDataSetLoadTimeInMillis(1000L);
        try {
            this.memoryProfiler.freeMemory();
            long timeBegin = System.currentTimeMillis();
            long memBegin = this.memoryProfiler.getMemoryUsedInBytes();
            int n = 10;
            DataSet dataSet = this.buildDataSet(n, this.dataProvider, this.dataLoader);
            this.memoryProfiler.freeMemory();
            long timeEnd = System.currentTimeMillis();
            long memEnd = this.memoryProfiler.getMemoryUsedInBytes();
            long mem = memEnd - memBegin;
            log.info("500 rows - Load time = " + Chronometer.formatElapsedTime((long)(timeEnd - timeBegin)));
            log.info("500 rows - Size of = " + MemoryProfiler.formatSize((long)dataSet.sizeOf()));
            log.info("500 rows - Memory consumption = " + MemoryProfiler.formatSize((long)mem));
            Assertions.assertThat((long)mem).isLessThan(0x100000L);
            Assertions.assertThat((Object)dataSet).isNotNull();
            Assertions.assertThat((int)dataSet.getProperties().length).isGreaterThan(0);
            Assertions.assertThat((int)dataSet.getRowCount()).isEqualTo(50 * n);
        }
        catch (DataSetException e) {
            Assertions.fail((String)"Load constraints violated.", (Throwable)e);
        }
    }

    @Test
    public void test50000Rows() throws Exception {
        DataSetSettings dataSetSettings = DataProviderServices.lookup().getDataSetSettings();
        dataSetSettings.setMaxDataSetLoadTimeInMillis(5000L);
        dataSetSettings.setMaxDataSetSizeInBytes(0x3200000L);
        try {
            this.memoryProfiler.freeMemory();
            long timeBegin = System.currentTimeMillis();
            long memBegin = this.memoryProfiler.getMemoryUsedInBytes();
            int n = 1000;
            DataSet dataSet = this.buildDataSet(n, this.dataProvider, this.dataLoader);
            this.memoryProfiler.freeMemory();
            long timeEnd = System.currentTimeMillis();
            long memEnd = this.memoryProfiler.getMemoryUsedInBytes();
            long mem = memEnd - memBegin;
            log.info("50000 rows - Load time = " + Chronometer.formatElapsedTime((long)(timeEnd - timeBegin)));
            log.info("50000 rows - Size of = " + MemoryProfiler.formatSize((long)dataSet.sizeOf()));
            log.info("50000 rows - Memory consumption = " + MemoryProfiler.formatSize((long)mem));
            Assertions.assertThat((long)mem).isLessThan(0x3200000L);
            Assertions.assertThat((Object)dataSet).isNotNull();
            Assertions.assertThat((int)dataSet.getProperties().length).isGreaterThan(0);
            Assertions.assertThat((int)dataSet.getRowCount()).isEqualTo(50 * n);
        }
        catch (DataSetException e) {
            Assertions.fail((String)"Load constraints violated.", (Throwable)e);
        }
    }

    @Test
    public void testLoadTimeExceeded() throws Exception {
        DataSetSettings dataSetSettings = DataProviderServices.lookup().getDataSetSettings();
        dataSetSettings.setMaxDataSetLoadTimeInMillis(1L);
        dataSetSettings.setMaxDataSetSizeInBytes(-1L);
        try {
            this.buildDataSet(1000, this.dataProvider, this.dataLoader);
            Assertions.failBecauseExceptionWasNotThrown(DataSetException.class);
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    @Test
    public void testDataSetSizeExceeded() throws Exception {
        DataSetSettings dataSetSettings = DataProviderServices.lookup().getDataSetSettings();
        dataSetSettings.setMaxDataSetLoadTimeInMillis(-1L);
        dataSetSettings.setMaxDataSetSizeInBytes(1L);
        try {
            this.buildDataSet(10, this.dataProvider, this.dataLoader);
            Assertions.failBecauseExceptionWasNotThrown(DataSetException.class);
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet buildDataSet(int n, DataProvider dataProvider, CSVDataLoader dataLoader) throws Exception {
        CompositeInputStream dataStream = new CompositeInputStream();
        try {
            dataStream.addPart(Thread.currentThread().getContextClassLoader().getResourceAsStream("data_header.csv"));
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("data_chunk.csv");
            for (int i = 0; i < n; ++i) {
                dataStream.addPart(is);
            }
            DataSet dataSet = dataLoader.load(dataProvider, (InputStream)dataStream);
            return dataSet;
        }
        finally {
            dataStream.close();
        }
    }
}

